/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.rest.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.processes.Utils.ProcessesUtils;
import org.exoplatform.processes.model.Work;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.rest.model.WorkEntity;
import org.exoplatform.processes.rest.model.WorkFlowEntity;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.service.StatusService;

public class EntityBuilder {
    private static final Log LOG = ExoLogger.getExoLogger(EntityBuilder.class);

    private EntityBuilder() {
    }

    public static WorkFlow fromEntity(WorkFlowEntity workFlowEntity) {
        if (workFlowEntity == null) {
            return null;
        }
        return new WorkFlow(workFlowEntity.getId(), workFlowEntity.getTitle(), workFlowEntity.getDescription(), workFlowEntity.getSummary(), workFlowEntity.getImage(), workFlowEntity.getHelpLink(), workFlowEntity.isEnabled(), workFlowEntity.getCreatorId(), workFlowEntity.getCreatedDate(), workFlowEntity.getModifierId(), workFlowEntity.getModifiedDate(), workFlowEntity.getProjectId(), workFlowEntity.getParentSpace() != null && workFlowEntity.getParentSpace().getId() != null ? workFlowEntity.getParentSpace().getId() : "", null, workFlowEntity.getAttachments(), workFlowEntity.getIllustrativeAttachment(), null, null, false, workFlowEntity.getRequestsCreators());
    }

    public static Work fromEntity(WorkEntity workEntity) {
        if (workEntity == null) {
            return null;
        }
        return new Work(workEntity.getId(), workEntity.getTitle(), workEntity.getDescription(), workEntity.getCreatorId(), workEntity.getCreatedTime(), workEntity.getModifiedTime(), workEntity.getTaskId(), workEntity.getIsDraft(), EntityBuilder.fromEntity(workEntity.getWorkFlow()));
    }

    public static WorkFlowEntity toEntity(WorkFlow workFlow, String expand) {
        if (workFlow == null) {
            return null;
        }
        StatusService statusService = (StatusService)CommonsUtils.getService(StatusService.class);
        List expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
        return new WorkFlowEntity(workFlow.getId(), workFlow.getTitle(), workFlow.getDescription(), workFlow.getSummary(), workFlow.getImage(), workFlow.getHelpLink(), workFlow.isEnabled(), workFlow.getCreatorId(), workFlow.getCreatedDate(), workFlow.getModifierId(), workFlow.getModifiedDate(), workFlow.getProjectId(), workFlow.getAttachments(), statusService.getStatuses(workFlow.getProjectId()), workFlow.getAcl(), ProcessesUtils.getProjectParentSpace(workFlow.getProjectId()), workFlow.isCanShowPending(), workFlow.getIllustrativeAttachment(), workFlow.getRequestsCreators());
    }

    public static WorkFlowEntity toEntity(WorkFlow workFlow) {
        if (workFlow == null) {
            return null;
        }
        WorkFlowEntity workFlowEntity = new WorkFlowEntity();
        workFlowEntity.setId(workFlow.getId());
        workFlowEntity.setTitle(workFlow.getTitle());
        workFlowEntity.setDescription(workFlow.getDescription());
        workFlowEntity.setSummary(workFlow.getSummary());
        workFlowEntity.setImage(workFlow.getImage());
        workFlowEntity.setHelpLink(workFlow.getHelpLink());
        workFlowEntity.setEnabled(workFlow.isEnabled());
        workFlowEntity.setCreatorId(workFlow.getCreatorId());
        workFlowEntity.setCreatedDate(workFlow.getCreatedDate());
        workFlowEntity.setModifierId(workFlow.getModifierId());
        workFlowEntity.setModifiedDate(workFlow.getModifiedDate());
        workFlowEntity.setProjectId(workFlow.getProjectId());
        workFlowEntity.setIllustrativeAttachment(workFlow.getIllustrativeAttachment());
        workFlowEntity.setAcl(workFlow.getAcl());
        return workFlowEntity;
    }

    public static List<WorkFlow> fromRestEntities(List<WorkFlowEntity> workFlowEntities) {
        if (CollectionUtils.isEmpty(workFlowEntities)) {
            return new ArrayList<WorkFlow>(Collections.emptyList());
        }
        List<WorkFlow> workFlows = workFlowEntities.stream().map(workEntity -> EntityBuilder.fromEntity(workEntity)).collect(Collectors.toList());
        return workFlows;
    }

    public static List<WorkFlowEntity> toRestEntities(List<WorkFlow> workFlowList, String expand) {
        if (CollectionUtils.isEmpty(workFlowList)) {
            return new ArrayList<WorkFlowEntity>(Collections.emptyList());
        }
        List<WorkFlowEntity> workFlowEntities = workFlowList.stream().map(workFlow -> EntityBuilder.toEntity(workFlow, expand)).collect(Collectors.toList());
        return workFlowEntities;
    }

    public static Work toWork(ProcessesService processesService, WorkEntity workEntity) {
        if (workEntity == null) {
            return null;
        }
        Work work = new Work(workEntity.getId(), workEntity.getTitle(), workEntity.getDescription(), workEntity.getStatus(), workEntity.isCompleted(), workEntity.getCreatedBy(), workEntity.getCreatedTime(), null, null, null, workEntity.getIsDraft(), workEntity.getDraftId(), workEntity.getProjectId());
        work.setAttachments(workEntity.getAttachments());
        if (workEntity.getWorkFlow() != null) {
            try {
                WorkFlow workFlow = processesService.getWorkFlow(workEntity.getWorkFlow().getId());
                if (workFlow != null) {
                    work.setProjectId(workFlow.getProjectId());
                }
            }
            catch (IllegalAccessException e) {
                LOG.warn("cannot get workFlow of work {}", new Object[]{work.getId()});
            }
        }
        return work;
    }

    public static WorkEntity toWorkEntity(ProcessesService processesService, Work work, String expand) {
        if (work == null) {
            return null;
        }
        List expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
        WorkEntity workEntity = new WorkEntity(work.getId(), work.getTitle(), work.getDescription(), work.getStatus(), work.isCompleted(), work.getCreatedBy(), work.getCreatedDate(), work.getProjectId());
        if (expandProperties.contains("comments")) {
            // empty if block
        }
        workEntity.setAttachments(work.getAttachments());
        try {
            workEntity.setDescription(HTMLSanitizer.sanitize((String)work.getDescription()));
        }
        catch (Exception e) {
            LOG.warn((Object)"Work description cannot be sanitized", (Throwable)e);
        }
        if (expandProperties.contains("workFlow")) {
            workEntity.setWorkFlow(EntityBuilder.toEntity(processesService.getWorkFlowByProjectId(work.getProjectId()), ""));
        }
        return workEntity;
    }

    public static WorkEntity toEntity(Work work) {
        if (work == null) {
            return null;
        }
        return new WorkEntity(work.getId(), work.getTitle(), work.getDescription(), work.getCreatorId(), work.getCreatedDate(), work.getModifiedDate(), work.getTaskId(), work.getIsDraft(), EntityBuilder.toEntity(work.getWorkFlow()));
    }

    public static List<WorkEntity> toWorkEntityList(ProcessesService processesService, List<Work> works, String expand) {
        if (CollectionUtils.isEmpty(works)) {
            return new ArrayList<WorkEntity>(Collections.emptyList());
        }
        return works.stream().map(work -> EntityBuilder.toWorkEntity(processesService, work, expand)).collect(Collectors.toList());
    }

    public static List<WorkEntity> toWorkEntityList(List<Work> works) {
        if (CollectionUtils.isEmpty(works)) {
            return new ArrayList<WorkEntity>(Collections.emptyList());
        }
        return works.stream().map(EntityBuilder::toEntity).collect(Collectors.toList());
    }
}

