/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.processes.entity.WorkFlowEntity;
import org.exoplatform.processes.model.ProcessesFilter;

public class WorkFlowDAO
extends GenericDAOJPAImpl<WorkFlowEntity, Long> {
    public List<WorkFlowEntity> findAllWorkFlowsByUser(long userId, int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findAllWorkFlowsByUser", WorkFlowEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkFlowEntity> findEnabledWorkFlowsByUser(long userId, int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findEnabledWorkFlowsByUser", WorkFlowEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkFlowEntity> findAllWorkFlows(int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findAllWorkFlows", WorkFlowEntity.class);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    private String buildWorkflowQuery(ProcessesFilter processesFilter, List<String> memberships) {
        String q = processesFilter.getQuery();
        Boolean enabled = processesFilter.getEnabled();
        Boolean manager = processesFilter.getManager();
        boolean isProcessManager = processesFilter.getIsProcessManager();
        String query = " ( workFlow.title like '%" + q + "%' OR workFlow.description like '%" + q + "%' OR workFlow.summary like '%" + q + "%' )";
        Object queryString = "SELECT DISTINCT workFlow FROM WorkFlow workFlow";
        if (enabled != null || Boolean.TRUE.equals(manager) || !isProcessManager) {
            if (memberships != null) {
                if (Boolean.FALSE.equals(manager)) {
                    queryString = (String)queryString + " LEFT JOIN workFlow.manager manager";
                }
                queryString = (String)queryString + " LEFT JOIN workFlow.participator participator";
            }
            if (StringUtils.isNotEmpty((CharSequence)q) || memberships != null || enabled != null) {
                queryString = (String)queryString + " WHERE";
                if (StringUtils.isNotEmpty((CharSequence)q)) {
                    queryString = (String)queryString + query;
                    queryString = (String)queryString + " AND";
                }
                if (enabled != null) {
                    queryString = (String)queryString + " workFlow.enabled = " + enabled;
                    queryString = (String)queryString + " AND";
                }
                if (memberships != null) {
                    if (Boolean.FALSE.equals(manager)) {
                        queryString = (String)queryString + " ( manager IN ('" + String.join((CharSequence)"','", this.getMembersShipGroup(memberships)) + "') ";
                        queryString = (String)queryString + " OR participator IN ('" + String.join((CharSequence)"','", memberships) + "')) ";
                    } else {
                        queryString = (String)queryString + " participator IN ('" + String.join((CharSequence)"','", memberships) + "') ";
                    }
                }
                if (((String)queryString).endsWith(" AND")) {
                    queryString = ((String)queryString).substring(0, ((String)queryString).length() - 4);
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)q)) {
            queryString = (String)queryString + " WHERE" + query;
        }
        return queryString;
    }

    private List<String> getMembersShipGroup(List<String> memberships) {
        return memberships.stream().map(s -> !s.startsWith("manager:/") && !s.startsWith("member:/") && !s.startsWith("*:/") ? s : s.replace("manager:", "").replace("member:", "").replace("*:", "")).collect(Collectors.toList());
    }

    private Query buildWorkflowQueryCriteria(ProcessesFilter processesFilter) {
        String q = processesFilter.getQuery();
        Boolean enabled = processesFilter.getEnabled();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(WorkFlowEntity.class);
        Root root = criteriaQuery.from(WorkFlowEntity.class);
        if (q != null) {
            ArrayList<Predicate> qPredicates = new ArrayList<Predicate>();
            qPredicates.add(criteriaBuilder.like((Expression)root.get("title"), "%" + q + "%"));
            qPredicates.add(criteriaBuilder.like((Expression)root.get("description"), "%" + q + "%"));
            qPredicates.add(criteriaBuilder.like((Expression)root.get("summary"), "%" + q + "%"));
            predicates.add(criteriaBuilder.or(qPredicates.toArray(new Predicate[0])));
        }
        if (enabled != null) {
            predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get("enabled"), (Object)enabled)}));
        }
        criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[0]));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get("id"))});
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        return query;
    }

    public List<WorkFlowEntity> findWorkFlows(ProcessesFilter processesFilter, int offset, int limit) {
        List resultList;
        Query query = this.buildWorkflowQueryCriteria(processesFilter);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public int countWorkFlows(ProcessesFilter processesFilter) {
        Query query = this.buildWorkflowQueryCriteria(processesFilter);
        return query.getMaxResults();
    }

    public List<WorkFlowEntity> findWorkFlows(ProcessesFilter processesFilter, List<String> memberships, int offset, int limit) {
        List resultList;
        String queryString = this.buildWorkflowQuery(processesFilter, memberships);
        Query query = this.getEntityManager().createQuery(queryString);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public int countWorkFlows(ProcessesFilter processesFilter, List<String> memberships) {
        String queryString = this.buildWorkflowQuery(processesFilter, memberships);
        TypedQuery query = this.getEntityManager().createQuery(queryString, Long.class);
        return query.getMaxResults();
    }

    public List<WorkFlowEntity> findEnabledWorkFlows(int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findEnabledWorkFlows", WorkFlowEntity.class);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkFlowEntity> findDisabledWorkFlows(int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findDisabledWorkFlows", WorkFlowEntity.class);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public WorkFlowEntity getWorkFlowByProjectId(long projectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.getWorkFlowByProjectId", WorkFlowEntity.class);
        query.setParameter("projectId", (Object)projectId);
        try {
            return (WorkFlowEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

