/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.social.client.api.net;

import org.apache.http.client.HttpClient;
import org.exoplatform.social.client.api.SocialClientLibException;

/**
 * Created by The eXo Platform SAS
 * Author : eXoPlatform
 *          exo@exoplatform.com
 * Jun 29, 2011  
 */
public interface SocialHttpClient extends HttpClient {
  public enum POLICY {
    NO_AUTH,
    BASIC_AUTH
  }
  /**
   * Setting the basic authenticate which uses 
   * the username/password in <code>SocialClientContext</code>
   */
  public void setBasicAuthenticateToRequest() throws SocialClientLibException;
}
