/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core;

import org.exoplatform.social.client.api.ClientServiceFactory;
import org.exoplatform.social.client.api.SocialClientContext;
import org.exoplatform.social.client.core.ClientServiceFactoryImplV1Alpha1;
import org.exoplatform.social.client.core.ClientServiceFactoryImplV1Alpha2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServiceFactoryHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ClientServiceFactoryHelper.class);
    private static ClientServiceFactory clientServiceFactory;
    private static String currentRestVersion;

    public static ClientServiceFactory getClientServiceFactory() {
        if (clientServiceFactory == null || ClientServiceFactoryHelper.isVersionChanged()) {
            currentRestVersion = SocialClientContext.getRestVersion();
            if (SocialClientContext.SupportedVersion.V1_ALPHA1.toString().equals(currentRestVersion)) {
                clientServiceFactory = new ClientServiceFactoryImplV1Alpha1();
            } else if (SocialClientContext.SupportedVersion.V1_ALPHA2.toString().equals(currentRestVersion)) {
                clientServiceFactory = new ClientServiceFactoryImplV1Alpha2();
            }
        }
        return clientServiceFactory;
    }

    private static boolean isVersionChanged() {
        if (!SocialClientContext.getRestVersion().equals(currentRestVersion)) {
            LOG.warn("restVersion changed, from: " + currentRestVersion + " to: " + SocialClientContext.getRestVersion());
            currentRestVersion = SocialClientContext.getRestVersion();
            return true;
        }
        return false;
    }

    static {
        currentRestVersion = null;
    }
}

