/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.SocialClientLibException;
import org.exoplatform.social.client.api.model.RestActivity;
import org.exoplatform.social.client.api.model.RestActivityStream;
import org.exoplatform.social.client.api.model.RestComment;
import org.exoplatform.social.client.api.model.RestIdentity;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.net.SocialHttpClientException;
import org.exoplatform.social.client.api.service.ActivityService;
import org.exoplatform.social.client.api.service.IdentityService;
import org.exoplatform.social.client.api.service.QueryParams;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.core.ClientServiceFactoryHelper;
import org.exoplatform.social.client.core.model.ModelImpl;
import org.exoplatform.social.client.core.model.RestActivityStreamImpl;
import org.exoplatform.social.client.core.model.RestCommentImpl;
import org.exoplatform.social.client.core.model.RestIdentityImpl;
import org.exoplatform.social.client.core.service.QueryParamsImpl;
import org.exoplatform.social.client.core.util.SocialHttpClientSupport;
import org.exoplatform.social.client.core.util.SocialJSONDecodingSupport;
import org.json.simple.parser.ParseException;

public class RestActivityImpl
extends ModelImpl
implements RestActivity {
    @Override
    public String getId() {
        return this.getFieldAsString(RestActivity.Field.ID.toString());
    }

    @Override
    public void setId(String id) {
        this.setField(RestActivity.Field.ID.toString(), id);
    }

    @Override
    public String getTitle() {
        return this.getFieldAsString(RestActivity.Field.TITLE.toString());
    }

    @Override
    public void setBody(String title) {
        this.setField(RestActivity.Field.BODY.toString(), title);
    }

    @Override
    public String getBody() {
        return this.getFieldAsString(RestActivity.Field.BODY.toString());
    }

    @Override
    public void setTitle(String title) {
        this.setField(RestActivity.Field.TITLE.toString(), title);
    }

    @Override
    public String getTitleId() {
        return this.getFieldAsString(RestActivity.Field.TITLE_ID.toString());
    }

    @Override
    public void setTitleId(String titleId) {
        this.setField(RestActivity.Field.TITLE_ID.toString(), titleId);
    }

    @Override
    public String getAppId() {
        return this.getFieldAsString(RestActivity.Field.APP_ID.toString());
    }

    @Override
    public void setAppId(String appId) {
        this.setField(RestActivity.Field.APP_ID.toString(), appId);
    }

    @Override
    public String getType() {
        return this.getFieldAsString(RestActivity.Field.TYPE.toString());
    }

    @Override
    public void setType(String type) {
        this.setField(RestActivity.Field.TYPE.toString(), type);
    }

    @Override
    public Long getPostedTime() {
        return (Long)this.getField(RestActivity.Field.POSTED_TIME.toString());
    }

    @Override
    public void setPostedTime(Long postedTime) {
        this.setField(RestActivity.Field.POSTED_TIME.toString(), postedTime);
    }

    @Override
    public Double getPriority() {
        return (Double)this.getField(RestActivity.Field.PRIORITY.toString());
    }

    @Override
    public void setPriority(Double priority) {
        this.setField(RestActivity.Field.PRIORITY.toString(), priority);
    }

    @Override
    public Map<String, String> getTemplateParams() {
        return this.getFieldAsMap(RestActivity.Field.TEMPLATE_PARAMS.toString());
    }

    @Override
    public void setTemplateParams(Map<String, String> templateParams) {
        this.setField(RestActivity.Field.TEMPLATE_PARAMS.toString(), templateParams);
    }

    @Override
    public String getIdentityId() {
        return this.getFieldAsString(RestActivity.Field.IDENTITY_ID.toString());
    }

    @Override
    public void setIdentityId(String identityId) {
        this.setField(RestActivity.Field.IDENTITY_ID.toString(), identityId);
    }

    @Override
    public boolean isLiked() {
        return Boolean.parseBoolean(this.getFieldAsString(RestActivity.Field.LIKED.toString()));
    }

    @Override
    public RestIdentity getPosterIdentity() throws SocialClientLibException {
        String posterIdentityString = this.getFieldAsString(RestActivity.Field.POSTER_IDENTITY.toString());
        RestIdentity restIdentity = null;
        if (posterIdentityString != null && posterIdentityString.length() > 0) {
            try {
                restIdentity = SocialJSONDecodingSupport.parser(RestIdentityImpl.class, posterIdentityString);
            }
            catch (Exception e) {
                throw new ServiceException(ActivityService.class, e.getMessage(), null);
            }
        } else {
            IdentityService service = ClientServiceFactoryHelper.getClientServiceFactory().createIdentityService();
            restIdentity = (RestIdentity)service.get(this.getIdentityId());
        }
        return restIdentity;
    }

    @Override
    public List<RestComment> getAvailableComments() {
        try {
            String commentsJSON = this.getFieldAsString(RestActivity.Field.COMMENTS.toString());
            List<RestComment> comments = SocialJSONDecodingSupport.JSONArrayObjectParser(RestCommentImpl.class, commentsJSON);
            return comments;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), null);
        }
    }

    @Override
    public void setAvailableComments(List<RestComment> restCommentList) {
    }

    @Override
    public int getTotalNumberOfComments() {
        return Integer.parseInt(this.getFieldAsString(RestActivity.Field.TOTAL_NUMBER_OF_COMMENTS.toString()));
    }

    @Override
    public List<RestComment> getTotalComments() throws SocialClientLibException {
        String GET_ACTIVITY_REQUEST_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true) + "activity/" + this.getId() + "/comments.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
            String responseContent = SocialHttpClientSupport.getContent(response);
            List<RestComment> comments = SocialJSONDecodingSupport.JSONArrayObjectParser(RestCommentImpl.class, responseContent);
            return comments;
        }
        catch (IOException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), null);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), null);
        }
    }

    @Override
    public RestActivityStream getActivityStream() throws SocialClientLibException {
        String activityStreamJSON = this.getFieldAsString(RestActivity.Field.ACTIVITY_STREAM.toString());
        RestActivityStream restActivityStream = null;
        try {
            if (activityStreamJSON != null && activityStreamJSON.length() > 0) {
                restActivityStream = SocialJSONDecodingSupport.parser(RestActivityStreamImpl.class, activityStreamJSON);
            } else {
                QueryParams queryParamBuilder = new QueryParamsImpl().append(QueryParams.ACTIVITY_STREAM_PARAM.setValue("t"));
                String GET_ACTIVITY_REQUEST_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true) + "activity/" + this.getId() + ".json?" + queryParamBuilder.buildQuery();
                HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
                SocialHttpClientSupport.handleError(response);
                RestActivity activity = SocialJSONDecodingSupport.parser(RestActivityImpl.class, response);
                restActivityStream = activity.getActivityStream();
                this.setField(RestActivity.Field.ACTIVITY_STREAM.toString(), activity.getFieldAsString(RestActivity.Field.ACTIVITY_STREAM.toString()));
            }
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), null);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), null);
        }
        catch (IOException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), null);
        }
        return restActivityStream;
    }

    @Override
    public String getTemplateParameter(String name) {
        Map<String, String> templateParams = this.getTemplateParams();
        if (templateParams != null) {
            return templateParams.get(name);
        }
        return null;
    }

    @Override
    public void addTemplateParameter(String name, String value) {
        Map<String, String> templateParams = this.getTemplateParams();
        if (templateParams == null) {
            templateParams = new HashMap<String, String>();
        }
        templateParams.put(name, value);
        this.setTemplateParams(templateParams);
    }

    @Override
    public int getTotalNumberOfLikes() {
        return Integer.parseInt(this.getFieldAsString(RestActivity.Field.TOTAL_NUMBER_OF_LIKES.toString()));
    }

    @Override
    public List<RestIdentity> getTotalLikes() throws SocialClientLibException {
        String GET_ACTIVITY_REQUEST_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true) + "activity/" + this.getId() + "/likes.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            SocialHttpClientSupport.handleError(response);
            List<RestIdentity> likedByIdentities = SocialJSONDecodingSupport.JSONArrayObjectParser(RestIdentityImpl.class, responseContent);
            return likedByIdentities;
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), null);
        }
        catch (IOException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), null);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), null);
        }
    }

    @Override
    public List<RestIdentity> getAvailableLikes() {
        try {
            String likedByIdentitiesJSON = this.getFieldAsString(RestActivity.Field.LIKED_BY_IDENTITIES.toString());
            List<RestIdentity> likedByIdentities = SocialJSONDecodingSupport.JSONArrayObjectParser(RestIdentityImpl.class, likedByIdentitiesJSON);
            return likedByIdentities;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), null);
        }
    }
}

