/*
 * Copyright (C) 2003-2010 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.social.common.jcr;

/**
 * NodeType reference.
 *
 * @author <a href="http://hoatle.net">hoatle (hoatlevan at gmail dot com)</a>
 * @since 1.2.0-GA
 * @since Nov 10, 2010
 */
public final class NodeType {
  /**
   * eXo Social Activity Node Type.
   */
  public static final String EXO_ACTIVITY = "exo:activity";

  /**
   * eXo Social Space Node Type.
   */
  public static final String EXO_SPACE = "exo:space";

  public static final String EXO_PRIVILEGEABLE = "exo:privilegeable";

  /**
   * eXo Social Relationship node type.
   */
  public static final String EXO_RELATIONSHIP = "exo:relationship";

  /* JCR Node Types */

   public static final String NT_BASE  = "nt:base";

   public static final String NT_UNSTRUCTURED = "nt:unstructured";

   public static final String NT_HIERARCHY_NODE = "nt:hierarchyNode";

   public static final String NT_FILE = "nt:file";

   public static final String NT_LINKED_FILE = "nt:linkedFile";

   public static final String NT_FOLDER = "nt:folder";

   public static final String NT_NODE_TYPE = "nt:nodeType";

   public static final String NT_PROPERTY_DEFINITION = "nt:propertyDefinition";

   public static final String NT_CHILD_NODE_DEFINITION = "nt:childNodeDefinition";

   public static final String NT_VERSION = "nt:version";

   public static final String NT_VERSION_HISTORY = "nt:versionHistory";

   public static final String NT_VERSION_LABELS = "nt:versionLabels";

   public static final String NT_VERSIONED_CHILD = "nt:versionedChild";

   public static final String NT_FROZEN_NODE = "nt:frozenNode";

   public static final String NT_QUERY = "nt:query";

   public static final String NT_RESOURCE = "nt:resource";

   public static final String MIX_REFERENCEABLE = "mix:referenceable";

   public static final String MIX_VERSIONABLE = "mix:versionable";

   public static final String MIX_LOCKABLE = "mix:lockable";

}

