/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.lifecycle;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;

public class LifeCycleCompletionService {
    private final String THREAD_NUMBER_KEY = "thread-number";
    private final String ASYNC_EXECUTION_KEY = "async-execution";
    private Executor executor;
    private ExecutorCompletionService ecs;
    private final int DEFAULT_THREAD_NUMBER = 1;
    private final boolean DEFAULT_ASYNC_EXECUTION = true;
    private int configThreadNumber;
    private boolean configAsyncExecution;

    public LifeCycleCompletionService(InitParams params) {
        ValueParam threadNumber = params.getValueParam("thread-number");
        ValueParam asyncExecution = params.getValueParam("async-execution");
        try {
            this.configThreadNumber = Integer.valueOf(threadNumber.getValue());
        }
        catch (Exception e) {
            this.configThreadNumber = 1;
        }
        try {
            this.configAsyncExecution = Boolean.valueOf(asyncExecution.getValue());
        }
        catch (Exception e) {
            this.configAsyncExecution = true;
        }
        this.executor = this.configAsyncExecution ? Executors.newFixedThreadPool(this.configThreadNumber) : new DirectExecutor();
        this.ecs = new ExecutorCompletionService(this.executor);
    }

    public void addTask(Callable callable) {
        this.ecs.submit(callable);
    }

    public void waitCompletionFinished() {
        try {
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        public void execute(Runnable runnable) {
            if (Thread.interrupted()) {
                throw new RuntimeException();
            }
            runnable.run();
        }
    }
}

