/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common;

import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static final String SPACE_STRING = " ";
    private static final String HTTP = "http";
    private static final String HTTP_PRTOCOL = "http://";
    private static final Pattern URL_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final int DOMAIN = 4;

    public static boolean isValidURL(String link) {
        try {
            String host;
            if (link == null || link.length() == 0) {
                return false;
            }
            if (link.indexOf(46) == -1) {
                return false;
            }
            if (!URL_PATTERN.matcher(link).matches()) {
                return false;
            }
            if (Util.hasValidDomain(link)) {
                return true;
            }
            URI uri = null;
            uri = new URI(IDN.toUnicode(link));
            String scheme = uri.getScheme();
            if (scheme == null) {
                link = HTTP_PRTOCOL + link;
                uri = new URI(IDN.toUnicode(link));
            }
            if ((host = uri.getHost()) != null && host.contains(SPACE_STRING)) {
                return false;
            }
            uri.toURL();
        }
        catch (URISyntaxException e) {
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private static boolean hasValidDomain(String link) {
        String domain;
        Matcher m;
        if (!link.startsWith(HTTP)) {
            link = HTTP_PRTOCOL + link;
        }
        return (m = URL_PATTERN.matcher(link)).matches() && (domain = m.group(4)) != null && !domain.contains(SPACE_STRING);
    }
}

