/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.oauth;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.SimpleOAuthValidator;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.core.oauth.OAuthSecurityToken;
import org.apache.shindig.social.opensocial.oauth.OAuthLookupService;

public class ExoContainerOAuthLookupService
implements OAuthLookupService {
    private static Map<String, String> sampleContainerUrlToAppIdMap = Maps.immutableMap((Object)"http://localhost:8080/gadgets/files/samplecontainer/examples/SocialHelloWorld.xml", (Object)"7810", (Object)"http://localhost:8080/gadgets/files/samplecontainer/examples/SocialActivitiesWorld.xml", (Object)"8355");
    private static Map<String, ArrayList<String>> sampleContainerAppInstalls = Maps.immutableMap((Object)"john.doe", (Object)Lists.newArrayList((Object[])new String[]{"7810", "8355"}));
    private static Map<String, String> sampleContainerSharedSecrets = Maps.immutableMap((Object)"7810", (Object)"SocialHelloWorldSharedSecret", (Object)"8355", (Object)"SocialActivitiesWorldSharedSecret");

    public boolean thirdPartyHasAccessToUser(OAuthMessage message, String appUrl, String userId) {
        String appId = this.getAppId(appUrl);
        return this.hasValidSignature(message, appUrl, appId) && this.userHasAppInstalled(userId, appId);
    }

    private boolean hasValidSignature(OAuthMessage message, String appUrl, String appId) {
        String sharedSecret = sampleContainerSharedSecrets.get(appId);
        if (sharedSecret == null) {
            return false;
        }
        OAuthServiceProvider provider = new OAuthServiceProvider(null, null, null);
        OAuthConsumer consumer = new OAuthConsumer(null, appUrl, sharedSecret, provider);
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        SimpleOAuthValidator validator = new SimpleOAuthValidator();
        try {
            validator.validateMessage(message, accessor);
        }
        catch (OAuthException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private boolean userHasAppInstalled(String userId, String appId) {
        List appInstalls = sampleContainerAppInstalls.get(userId);
        if (appInstalls != null) {
            for (String appInstall : appInstalls) {
                if (!appInstall.equals(appId)) continue;
                return true;
            }
        }
        return false;
    }

    public SecurityToken getSecurityToken(String appUrl, String userId) {
        return new OAuthSecurityToken(userId, appUrl, this.getAppId(appUrl), "samplecontainer");
    }

    private String getAppId(String appUrl) {
        return sampleContainerUrlToAppIdMap.get(appUrl);
    }
}

