/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.value.BooleanValue;
import org.exoplatform.services.jcr.impl.core.value.DoubleValue;
import org.exoplatform.services.jcr.impl.core.value.LongValue;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.social.core.identity.ProfileConfig;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRStorage {
    private NodeHierarchyCreator nodeHierarchyCreator;
    private static final String IDENTITY_NODETYPE = "exo:identity".intern();
    private static final String IDENTITY_APP = "Social_Identity".intern();
    private static final String PROFILE_APP = "Social_Profile".intern();
    private static final String PROFILE_NODETYPE = "exo:profile".intern();
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String IDENTITY_REMOTEID = "exo:remoteId".intern();
    private static final String IDENTITY_PROVIDERID = "exo:providerId".intern();
    private static final String PROFILE_IDENTITY = "exo:identity".intern();
    private ProfileConfig config = null;

    public JCRStorage(NodeHierarchyCreator nodeHierarchyCreator) {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    private Node getIdentityServiceHome() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node appsNode = this.nodeHierarchyCreator.getPublicApplicationNode(sProvider);
        try {
            return appsNode.getNode(IDENTITY_APP);
        }
        catch (PathNotFoundException ex) {
            Node appNode = appsNode.addNode(IDENTITY_APP, NT_UNSTRUCTURED);
            appsNode.save();
            return appNode;
        }
    }

    private ProfileConfig getConfig() {
        if (this.config == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.config = (ProfileConfig)container.getComponentInstanceOfType(ProfileConfig.class);
        }
        return this.config;
    }

    private Node getProfileServiceHome() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node appsNode = this.nodeHierarchyCreator.getPublicApplicationNode(sProvider);
        try {
            return appsNode.getNode(PROFILE_APP);
        }
        catch (PathNotFoundException ex) {
            Node appNode = appsNode.addNode(PROFILE_APP, NT_UNSTRUCTURED);
            appsNode.save();
            return appNode;
        }
    }

    public void saveIdentity(Identity identity) throws Exception {
        Node identityNode;
        Node identityHomeNode = this.getIdentityServiceHome();
        if (identity.getId() == null) {
            identityNode = identityHomeNode.addNode(IDENTITY_NODETYPE, IDENTITY_NODETYPE);
            identityNode.addMixin("mix:referenceable");
        } else {
            identityNode = identityHomeNode.getSession().getNodeByUUID(identity.getId());
        }
        identityNode.setProperty(IDENTITY_REMOTEID, identity.getRemoteId());
        identityNode.setProperty(IDENTITY_PROVIDERID, identity.getProviderId());
        if (identity.getId() == null) {
            identityHomeNode.save();
            identity.setId(identityNode.getUUID());
        } else {
            identityNode.save();
        }
    }

    public Identity getIdentity(String id) throws Exception {
        Node identityNode;
        Node identityHomeNode = this.getIdentityServiceHome();
        try {
            identityNode = identityHomeNode.getSession().getNodeByUUID(id);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        Identity identity = new Identity(identityNode.getUUID());
        identity.setProviderId(identityNode.getProperty(IDENTITY_PROVIDERID).getString());
        identity.setRemoteId(identityNode.getProperty(IDENTITY_REMOTEID).getString());
        return identity;
    }

    public Identity getIdentityByRemoteId(String identityProvider, String id) throws Exception {
        Node identityHomeNode = this.getIdentityServiceHome();
        StringBuffer queryString = new StringBuffer("/").append(identityHomeNode.getPath()).append("/").append(IDENTITY_NODETYPE).append("[(@").append(IDENTITY_PROVIDERID).append("='").append(identityProvider).append("' and @").append(IDENTITY_REMOTEID).append("='").append(id.replaceAll("'", "''")).append("')]");
        QueryManager queryManager = identityHomeNode.getSession().getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryString.toString(), "xpath");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        Identity identity = null;
        if (nodeIterator.getSize() == 1L) {
            Node identityNode = (Node)nodeIterator.next();
            identity = new Identity(identityNode.getUUID());
            identity.setProviderId(identityNode.getProperty(IDENTITY_PROVIDERID).getString());
            identity.setRemoteId(identityNode.getProperty(IDENTITY_REMOTEID).getString());
        }
        return identity;
    }

    public void saveProfile(Profile p) throws Exception {
        Node profileNode;
        Node profileHomeNode = this.getProfileServiceHome();
        if (p.getIdentity().getId() == null) {
            throw new Exception("the identity has to be saved before saving the profile");
        }
        if (p.getId() == null) {
            profileNode = profileHomeNode.addNode(PROFILE_NODETYPE, PROFILE_NODETYPE);
            profileNode.addMixin("mix:referenceable");
            Node identityNode = profileHomeNode.getSession().getNodeByUUID(p.getIdentity().getId());
            profileNode.setProperty(PROFILE_IDENTITY, identityNode);
        } else {
            profileNode = profileHomeNode.getSession().getNodeByUUID(p.getId());
        }
        this.saveProfile(p, profileNode);
        if (p.getId() == null) {
            System.out.println("saving all the profileHomeNode");
            profileHomeNode.save();
            p.setId(profileNode.getUUID());
        } else {
            System.out.println("saving the profileNode");
            profileNode.save();
        }
    }

    protected void saveProfile(Profile p, Node n) throws Exception, IOException {
        Map<String, Object> props = p.getProperties();
        Iterator<String> it = props.keySet().iterator();
        for (String name : props.keySet()) {
            if (name.contains(":")) continue;
            String[] propValue = props.get(name);
            if (this.isForcedMultiValue(name)) {
                if (propValue instanceof String) {
                    String[] arr = new String[]{(String)propValue};
                    propValue = arr;
                }
                this.setProperty(name, propValue, n);
                continue;
            }
            if (propValue instanceof String) {
                n.setProperty(name, (String)propValue);
                System.out.println("setting the prop " + name + " = " + propValue);
                continue;
            }
            if (propValue instanceof Double) {
                n.setProperty(name, ((Double)propValue).doubleValue());
                System.out.println("setting the prop " + name + " = " + propValue);
                continue;
            }
            if (propValue instanceof Boolean) {
                n.setProperty(name, ((Boolean)propValue).booleanValue());
                System.out.println("setting the prop " + name + " = " + propValue);
                continue;
            }
            if (propValue instanceof Long) {
                n.setProperty(name, ((Long)propValue).longValue());
                System.out.println("setting the prop " + name + " = " + propValue);
                continue;
            }
            if (propValue instanceof String[] && propValue.length == 1) {
                n.setProperty(name, propValue[0]);
                System.out.println("setting the prop " + name + " = " + propValue);
                continue;
            }
            if (propValue instanceof String[]) {
                this.setProperty(name, propValue, n);
                continue;
            }
            if (!(propValue instanceof List)) continue;
            this.setProperty(name, (List)propValue, n);
        }
    }

    private void setProperty(String name, List<Map> props, Node n) throws Exception, ConstraintViolationException, VersionException {
        System.out.println("setting the List prop " + name + " = " + props);
        String ntName = this.getNodeTypeName(name);
        if (ntName == null) {
            throw new Exception("no nodeType is defined for " + name);
        }
        NodeIterator nIt = n.getNodes(name);
        while (nIt.hasNext()) {
            Node currNode = nIt.nextNode();
            currNode.remove();
        }
        for (Map prop : props) {
            Node propNode = n.addNode(name, ntName);
            for (String key : prop.keySet()) {
                Object propValue = prop.get(key);
                if (propValue instanceof String) {
                    propNode.setProperty(key, (String)propValue);
                    System.out.println("setting the prop String " + key + " = " + propValue);
                    continue;
                }
                if (propValue instanceof Double) {
                    propNode.setProperty(key, ((Double)propValue).doubleValue());
                    System.out.println("setting the prop Double" + key + " = " + propValue);
                    continue;
                }
                if (propValue instanceof Boolean) {
                    propNode.setProperty(key, ((Boolean)propValue).booleanValue());
                    System.out.println("setting the prop Boolean" + key + " = " + propValue);
                    continue;
                }
                if (!(propValue instanceof Long)) continue;
                propNode.setProperty(key, ((Long)propValue).longValue());
                System.out.println("setting the prop Long" + key + " = " + propValue);
            }
        }
    }

    private void setProperty(String name, String[] propValue, Node n) throws IOException, RepositoryException, ConstraintViolationException, VersionException {
        ArrayList<StringValue> values = new ArrayList<StringValue>();
        for (String value : propValue) {
            if (value == null || value.length() <= 0) continue;
            values.add(new StringValue(value));
            System.out.println("setting the multi prop " + name + " = " + value);
        }
        n.setProperty(name, values.toArray(new Value[values.size()]));
    }

    public void loadProfile(Profile p) throws Exception {
        Node profileHomeNode = this.getProfileServiceHome();
        if (p.getIdentity().getId() == null) {
            throw new Exception("the identity has to be saved before loading the profile");
        }
        Node idNode = profileHomeNode.getSession().getNodeByUUID(p.getIdentity().getId());
        PropertyIterator it = idNode.getReferences();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            System.out.println("is the profile NT? " + prop.getParent().getPrimaryNodeType().getName() + " " + prop.getParent().getUUID());
            if (!prop.getParent().isNodeType(PROFILE_NODETYPE)) continue;
            System.out.println("found the profile");
            Node n = prop.getParent();
            p.setId(n.getUUID());
            this.loadProfile(p, n);
            return;
        }
        System.out.println("did not find the profile");
    }

    protected boolean isForcedMultiValue(String key) {
        return this.getConfig().isForcedMultiValue(key);
    }

    protected String getNodeTypeName(String nodeName) {
        return this.getConfig().getNodeType(nodeName);
    }

    protected void loadProfile(Profile p, Node n) throws RepositoryException {
        System.out.println("Loading the profile");
        PropertyIterator props = n.getProperties();
        this.copyPropertiesToMap(props, p.getProperties());
        System.out.println("finished to load the props");
        NodeIterator it = n.getNodes();
        while (it.hasNext()) {
            Node node = it.nextNode();
            System.out.println("Loading the node:" + node.getName());
            List l = (List)p.getProperty(node.getName());
            if (l == null) {
                p.setProperty(node.getName(), new ArrayList());
                l = (List)p.getProperty(node.getName());
            }
            l.add(this.copyPropertiesToMap(node.getProperties(), new HashMap()));
            System.out.println("finish Loading the node:" + node.getName());
        }
        System.out.println("nodetype: " + n.getPrimaryNodeType().getName());
    }

    private Map copyPropertiesToMap(PropertyIterator props, Map map) throws RepositoryException {
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            if (prop.getName().contains(":")) continue;
            try {
                Value v = prop.getValue();
                if (v instanceof StringValue) {
                    map.put(prop.getName(), v.getString());
                } else if (v instanceof LongValue) {
                    map.put(prop.getName(), v.getLong());
                } else if (v instanceof DoubleValue) {
                    map.put(prop.getName(), v.getDouble());
                } else if (v instanceof BooleanValue) {
                    map.put(prop.getName(), v.getBoolean());
                }
                System.out.println("loading " + prop.getName() + " = " + v.getString());
            }
            catch (ValueFormatException e) {
                System.out.println("trying multivalue");
                Value[] values = prop.getValues();
                ArrayList<String> res = new ArrayList<String>();
                for (Value v : values) {
                    res.add(v.getString());
                    System.out.println("loading multi" + prop.getName() + " = " + v.getString());
                }
                map.put(prop.getName(), res.toArray(new String[res.size()]));
            }
        }
        return map;
    }

    public String getType(String nodetype, String property) throws Exception {
        PropertyDefinition[] pDefs;
        System.out.println("getType(" + nodetype + ", " + property + ")");
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService sProviderService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        NodeTypeManager ntManager = this.getProfileServiceHome().getSession().getWorkspace().getNodeTypeManager();
        NodeType nt = ntManager.getNodeType(nodetype);
        for (PropertyDefinition pDef : pDefs = nt.getDeclaredPropertyDefinitions()) {
            if (!pDef.getName().equals(property)) continue;
            System.out.println("getType(" + nodetype + ", " + property + ") ==" + pDef.getRequiredType());
            return PropertyType.nameFromValue((int)pDef.getRequiredType());
        }
        return null;
    }
}

