/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.relationship.storage;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Property;
import org.exoplatform.social.core.relationship.Relationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRStorage {
    private NodeHierarchyCreator nodeHierarchyCreator;
    private IdentityManager identityManager;
    private static final String RELATION_NODETYPE = "exo:relationship".intern();
    private static final String RELATION_APP = "Social_Relationship".intern();
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String PROPERTY_ISSYMETRIC = "exo:isSymetric".intern();
    private static final String PROPERTY_STATUS = "exo:status".intern();
    private static final String PROPERTY_NAME = "exo:name".intern();
    private static final String PROPERTY_INITIATOR = "exo:initiator".intern();
    private static final String PROPERTY_NODETYPE = "exo:relationshipProperty".intern();
    private static final String RELATION_IDENTITY1 = "exo:identity1Id".intern();
    private static final String RELATION_IDENTITY2 = "exo:identity2Id".intern();

    public JCRStorage(NodeHierarchyCreator nodeHierarchyCreator, IdentityManager identityManager) {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.identityManager = identityManager;
    }

    private Node getRelationshipServiceHome() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node appsNode = this.nodeHierarchyCreator.getPublicApplicationNode(sProvider);
        try {
            return appsNode.getNode(RELATION_APP);
        }
        catch (PathNotFoundException ex) {
            Node appNode = appsNode.addNode(RELATION_APP, NT_UNSTRUCTURED);
            appsNode.save();
            return appNode;
        }
    }

    public void saveRelationship(Relationship relationship) throws Exception {
        Node relationshipNode;
        Node relationshipHomeNode = this.getRelationshipServiceHome();
        if (relationship.getId() == null) {
            relationshipNode = relationshipHomeNode.addNode(RELATION_NODETYPE, RELATION_NODETYPE);
            relationshipNode.addMixin("mix:referenceable");
        } else {
            relationshipNode = relationshipHomeNode.getSession().getNodeByUUID(relationship.getId());
        }
        Node id1Node = relationshipHomeNode.getSession().getNodeByUUID(relationship.getIdentity1().getId());
        Node id2Node = relationshipHomeNode.getSession().getNodeByUUID(relationship.getIdentity2().getId());
        relationshipNode.setProperty(RELATION_IDENTITY1, id1Node);
        relationshipNode.setProperty(RELATION_IDENTITY2, id2Node);
        relationshipNode.setProperty(PROPERTY_STATUS, relationship.getStatus().toString());
        this.updateProperties(relationship, relationshipNode);
        if (relationship.getId() == null) {
            relationshipHomeNode.save();
            relationship.setId(relationshipNode.getUUID());
        } else {
            relationshipNode.save();
        }
        this.loadProperties(relationship, relationshipNode);
    }

    private void updateProperties(Relationship relationship, Node relationshipNode) throws Exception {
        List<Property> properties = relationship.getProperties();
        NodeIterator oldNodes = relationshipNode.getNodes(PROPERTY_NODETYPE);
        while (oldNodes.hasNext()) {
            Node node = (Node)oldNodes.next();
            String uuid = node.getUUID();
            Boolean toRemove = true;
            for (Property property : properties) {
                if (!uuid.equals(property.getId())) continue;
                toRemove = false;
                break;
            }
            if (!toRemove.booleanValue()) continue;
            node.remove();
        }
        for (Property property : properties) {
            Node propertyNode;
            if (property.getId() == null) {
                propertyNode = relationshipNode.addNode(PROPERTY_NODETYPE, PROPERTY_NODETYPE);
                propertyNode.addMixin("mix:referenceable");
            } else {
                propertyNode = relationshipNode.getSession().getNodeByUUID(relationship.getId());
            }
            propertyNode.setProperty(PROPERTY_NAME, property.getName());
            propertyNode.setProperty(PROPERTY_ISSYMETRIC, property.isSymetric());
            propertyNode.setProperty(PROPERTY_STATUS, property.getStatus().toString());
            if (property.getInitiator() == null) continue;
            Node relationshipHomeNode = this.getRelationshipServiceHome();
            Node initiatorNode = relationshipHomeNode.getSession().getNodeByUUID(property.getInitiator().getId());
            propertyNode.setProperty(PROPERTY_INITIATOR, initiatorNode);
        }
    }

    public Relationship getRelationship(String uuid) throws Exception {
        Node relationshipNode;
        Node relationshipHomeNode = this.getRelationshipServiceHome();
        try {
            relationshipNode = relationshipHomeNode.getSession().getNodeByUUID(uuid);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        ExoContainer container = ExoContainerContext.getContainerByName((String)"portal");
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        Relationship relationship = new Relationship(relationshipNode.getUUID());
        Node idNode = relationshipNode.getProperty(RELATION_IDENTITY1).getNode();
        Identity id = identityManager.getIdentityById(idNode.getUUID());
        relationship.setIdentity1(id);
        idNode = relationshipNode.getProperty(RELATION_IDENTITY2).getNode();
        id = identityManager.getIdentityById(idNode.getUUID());
        relationship.setIdentity2(id);
        relationship.setStatus(Relationship.Type.valueOf(relationshipNode.getProperty(PROPERTY_STATUS).getString()));
        this.loadProperties(relationship, relationshipNode);
        return relationship;
    }

    private void loadProperties(Relationship relationship, Node relationshipNode) throws Exception {
        NodeIterator nodes = relationshipNode.getNodes(PROPERTY_NODETYPE);
        ArrayList<Property> props = new ArrayList<Property>();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            Property property = new Property();
            property.setId(node.getUUID());
            property.setName(node.getProperty(PROPERTY_NAME).getString());
            property.setSymetric(node.getProperty(PROPERTY_ISSYMETRIC).getBoolean());
            property.setStatus(Relationship.Type.valueOf(node.getProperty(PROPERTY_STATUS).getString()));
            if (node.hasProperty(PROPERTY_INITIATOR)) {
                Node idNode = node.getProperty(PROPERTY_INITIATOR).getNode();
                Identity id = this.identityManager.getIdentityById(idNode.getUUID());
                property.setInitiator(id);
            }
            props.add(property);
        }
        relationship.setProperties(props);
    }

    public List<Relationship> getRelationshipByIdentity(Identity identity) throws Exception {
        if (identity.getId() == null) {
            return null;
        }
        return this.getRelationshipByIdentityId(identity.getId());
    }

    public List<Relationship> getRelationshipByIdentityId(String identityId) throws Exception {
        Node relationshipHomeNode = this.getRelationshipServiceHome();
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        if (identityId == null) {
            return null;
        }
        Node identityNode = relationshipHomeNode.getSession().getNodeByUUID(identityId);
        PropertyIterator refNodes = identityNode.getReferences();
        while (refNodes.hasNext()) {
            javax.jcr.Property property = (javax.jcr.Property)refNodes.next();
            Node node = property.getParent();
            if (!node.isNodeType(RELATION_NODETYPE)) continue;
            results.add(this.getRelationship(node.getUUID()));
        }
        return results;
    }

    public List<Identity> getRelationshipIdentitiesByIdentity(Identity identity) throws Exception {
        Node relationshipHomeNode = this.getRelationshipServiceHome();
        ArrayList<Identity> results = new ArrayList<Identity>();
        if (identity.getId() == null) {
            return null;
        }
        Node identityNode = relationshipHomeNode.getSession().getNodeByUUID(identity.getId());
        PropertyIterator refNodes = identityNode.getReferences();
        while (refNodes.hasNext()) {
            Node relationshipNode;
            javax.jcr.Property property = (javax.jcr.Property)refNodes.next();
            Node node = property.getParent();
            if (!node.isNodeType(RELATION_NODETYPE)) continue;
            try {
                relationshipNode = relationshipHomeNode.getSession().getNodeByUUID(node.getUUID());
            }
            catch (ItemNotFoundException e) {
                continue;
            }
            Node idNode = relationshipNode.getProperty(RELATION_IDENTITY1).getNode();
            String sId = idNode.getUUID();
            if (!sId.equals(identity.getId())) {
                results.add(this.identityManager.getIdentityById(idNode.getUUID()));
                continue;
            }
            idNode = relationshipNode.getProperty(RELATION_IDENTITY2).getNode();
            results.add(this.identityManager.getIdentityById(idNode.getUUID()));
        }
        return results;
    }
}

