/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.social.core.identity.model;


import java.util.Map;
import java.util.HashMap;


public class Profile {
  private Map<String, Object> properties = new HashMap<String, Object>();
  private Identity identity;
  private String id;

  public Profile(Identity id) {
    this.identity = id;
  }

  public Identity getIdentity() {
    return identity;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Object getProperty(String name) {
    return properties.get(name);
  }

  public void setProperty(String name, Object value) {
    properties.put(name, value);
  }

  public boolean contains(String name) {
    return properties.containsKey(name);  
  }

  public Map<String, Object> getProperties() {
    return properties;
  }

  public void removeProperty(String name) {
    properties.remove(name);
  }

  /**
   * @deprecated 
   * @param name
   * @return
   */
  public Object getPropertyValue(String name) {
    return getProperty(name);
  }

  public String getFullName() {
    return getProperty("firstName") + " " + getProperty("lastName");
  }

}
