/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.JCRStorage;
import org.exoplatform.social.core.identity.ProfileFiler;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.space.impl.SocialDataLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityManager {
    private Map<String, IdentityProvider> identityProviders = new HashMap<String, IdentityProvider>();
    private JCRStorage storage;

    public IdentityManager(SocialDataLocation dataLocation, IdentityProvider ip) throws Exception {
        this.storage = new JCRStorage(dataLocation);
        ip.setIdentityManager(this);
        this.addIdentityProvider(ip);
    }

    public Identity getIdentityById(String id) throws Exception {
        return this.getIdentityById(id, true);
    }

    public Identity getIdentityById(String id, boolean loadProfile) throws Exception {
        Identity identity = this.storage.getIdentity(id);
        if (identity == null) {
            return null;
        }
        if (loadProfile) {
            identity = this.identityProviders.get(identity.getProviderId()).getIdentityByRemoteId(identity);
        }
        return identity;
    }

    public void addIdentityProvider(IdentityProvider idProvider) {
        this.identityProviders.put(idProvider.getName(), idProvider);
    }

    public Identity getIdentityByRemoteId(String providerId, String remoteId) throws Exception {
        return this.getIdentityByRemoteId(providerId, remoteId, true);
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFiler profileFilter) throws Exception {
        return this.storage.getIdentitiesByProfileFilter(providerId, profileFilter);
    }

    public List<Identity> getIdentitiesByProfileFilter(ProfileFiler profileFilter) throws Exception {
        return this.getIdentitiesByProfileFilter(null, profileFilter);
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFiler profileFilter) throws Exception {
        return this.storage.getIdentitiesFilterByAlphaBet(providerId, profileFilter);
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(ProfileFiler profileFilter) throws Exception {
        return this.getIdentitiesFilterByAlphaBet(null, profileFilter);
    }

    public Identity getIdentityByRemoteId(String providerId, String remoteId, boolean loadProfile) throws Exception {
        Identity identity = this.storage.getIdentityByRemoteId(providerId, remoteId);
        if (identity == null) {
            identity = this.getNewIdentity(providerId, remoteId);
        }
        if (loadProfile) {
            IdentityProvider identityProvider = this.identityProviders.get(identity.getProviderId());
            identity = identityProvider.getIdentityByRemoteId(identity);
        }
        return identity;
    }

    public Identity getNewIdentity(String providerId, String remoteId) throws Exception {
        Identity identity = new Identity();
        identity.setProviderId(providerId);
        identity.setRemoteId(remoteId);
        this.saveIdentity(identity);
        return identity;
    }

    public void saveIdentity(Identity identity) throws Exception {
        this.storage.saveIdentity(identity);
        this.identityProviders.get(identity.getProviderId()).onSaveIdentity(identity);
    }

    public void saveProfile(Profile p) throws Exception {
        IdentityProvider prov = this.identityProviders.get(p.getIdentity().getProviderId());
        prov.saveProfile(p);
    }

    public List<Identity> getIdentities(String providerId) throws Exception {
        return this.getIdentities(providerId, true);
    }

    public List<Identity> getIdentities(String providerId, boolean loadProfile) throws Exception {
        IdentityProvider ip = this.identityProviders.get(providerId);
        List<String> userids = ip.getAllUserId();
        ArrayList<Identity> ids = new ArrayList<Identity>();
        for (String userId : userids) {
            ids.add(this.getIdentityByRemoteId(providerId, userId, loadProfile));
        }
        return ids;
    }

    protected JCRStorage getStorage() {
        return this.storage;
    }
}

