/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.value.BooleanValue;
import org.exoplatform.services.jcr.impl.core.value.DoubleValue;
import org.exoplatform.services.jcr.impl.core.value.LongValue;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.ProfileConfig;
import org.exoplatform.social.core.identity.ProfileFiler;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.model.ProfileAttachment;
import org.exoplatform.social.space.JCRSessionManager;
import org.exoplatform.social.space.impl.SocialDataLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRStorage {
    private static final String IDENTITY_NODETYPE = "exo:identity".intern();
    private static final String PROFILE_NODETYPE = "exo:profile".intern();
    private static final String IDENTITY_REMOTEID = "exo:remoteId".intern();
    private static final String IDENTITY_PROVIDERID = "exo:providerId".intern();
    private static final String PROFILE_IDENTITY = "exo:identity".intern();
    private static final String PROFILE_AVATAR = "avatar".intern();
    private static final String JCR_UUID = "jcr:uuid".intern();
    private ProfileConfig config = null;
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private static final Log LOG = ExoLogger.getExoLogger(JCRStorage.class);

    public JCRStorage(SocialDataLocation dataLocation) {
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
    }

    private Node getIdentityServiceHome(Session session) throws Exception {
        String path = this.dataLocation.getSocialIdentityHome();
        return session.getRootNode().getNode(path);
    }

    private ProfileConfig getConfig() {
        if (this.config == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.config = (ProfileConfig)container.getComponentInstanceOfType(ProfileConfig.class);
        }
        return this.config;
    }

    private Node getProfileServiceHome(Session session) throws Exception {
        String path = this.dataLocation.getSocialProfileHome();
        return session.getRootNode().getNode(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIdentity(Identity identity) {
        Session session = this.sessionManager.openSession();
        try {
            Node identityNode;
            Node identityHomeNode = this.getIdentityServiceHome(session);
            if (identity.getId() == null) {
                identityNode = identityHomeNode.addNode(IDENTITY_NODETYPE, IDENTITY_NODETYPE);
                identityNode.addMixin("mix:referenceable");
            } else {
                identityNode = session.getNodeByUUID(identity.getId());
            }
            identityNode.setProperty(IDENTITY_REMOTEID, identity.getRemoteId());
            identityNode.setProperty(IDENTITY_PROVIDERID, identity.getProviderId());
            if (identity.getId() == null) {
                identityHomeNode.save();
                identity.setId(identityNode.getUUID());
            } else {
                identityNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("failed to save identity " + identity), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity findIdentityById(String identityId) throws Exception {
        Session session = this.sessionManager.openSession();
        Node identityNode = null;
        try {
            identityNode = session.getNodeByUUID(identityId);
            Identity identity = this.getIdentity(identityNode);
            return identity;
        }
        catch (ItemNotFoundException e) {
            LOG.warn((Object)("failed to load identity " + identityId));
            Identity identity = null;
            return identity;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getAllIdentities() {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        try {
            Session session = this.sessionManager.openSession();
            Node identityHomeNode = this.getIdentityServiceHome(session);
            NodeIterator iter = identityHomeNode.getNodes();
            while (iter.hasNext()) {
                Node identityNode = iter.nextNode();
                Identity identity = this.getIdentity(identityNode);
                identities.add(identity);
            }
            ArrayList<Identity> arrayList = identities;
            return arrayList;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading identities", (Throwable)e);
            List<Identity> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity findIdentity(String providerId, String remoteId) throws Exception {
        Session session = this.sessionManager.openSession();
        Identity identity = null;
        try {
            Node identityHomeNode = this.getIdentityServiceHome(session);
            StringBuffer queryString = new StringBuffer("/").append(identityHomeNode.getPath()).append("/").append(IDENTITY_NODETYPE).append("[(@").append(IDENTITY_PROVIDERID).append("='").append(providerId).append("' and @").append(IDENTITY_REMOTEID).append("='").append(remoteId.replaceAll("'", "''")).append("')]");
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString.toString(), "xpath");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            if (nodeIterator.getSize() == 1L) {
                Node identityNode = (Node)nodeIterator.next();
                identity = new Identity(identityNode.getUUID());
                identity.setProviderId(identityNode.getProperty(IDENTITY_PROVIDERID).getString());
                identity.setRemoteId(identityNode.getProperty(IDENTITY_REMOTEID).getString());
            } else {
                LOG.debug((Object)("No node found for identity  " + providerId + ":" + remoteId));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("failed to load identity by remote id : " + providerId + ":" + remoteId), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return identity;
    }

    public Identity getIdentity(Node identityNode) throws Exception {
        Identity identity = null;
        identity = new Identity(identityNode.getUUID());
        identity.setProviderId(identityNode.getProperty(IDENTITY_PROVIDERID).getString());
        identity.setRemoteId(identityNode.getProperty(IDENTITY_REMOTEID).getString());
        Profile profile = new Profile(identity);
        this.loadProfile(profile);
        identity.setProfile(profile);
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getIdentitiesByProfileFilter(String identityProvider, ProfileFiler profileFilter) throws Exception {
        Session session = this.sessionManager.openSession();
        Node profileHomeNode = this.getProfileServiceHome(session);
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        NodeIterator nodeIterator = null;
        String userName = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/").append(profileHomeNode.getPath()).append("/").append(PROFILE_NODETYPE);
            userName = profileFilter.getName().trim();
            String position = profileFilter.getPosition().trim();
            String gender = profileFilter.getGender().trim();
            if (userName.length() > 0) {
                userName = userName == "" || userName.length() == 0 ? "*" : userName;
                userName = userName.charAt(0) != '*' ? "*" + userName : userName;
                userName = userName.charAt(userName.length() - 1) != '*' ? (userName = userName + "*") : userName;
                userName = userName.indexOf("*") >= 0 ? userName.replace("*", ".*") : userName;
                userName = userName.indexOf("%") >= 0 ? userName.replace("%", ".*") : userName;
                Pattern.compile(userName);
            }
            if (position.length() != 0 || gender.length() != 0) {
                queryString.append("[");
            }
            if (position.length() != 0) {
                if (position.indexOf("*") < 0) {
                    if (position.charAt(0) != '*') {
                        position = "*" + position;
                    }
                    if (position.charAt(position.length() - 1) != '*') {
                        position = position + "*";
                    }
                }
                queryString.append("jcr:contains(@position, ").append("'").append(position).append("')");
            }
            if (gender.length() != 0) {
                if (position.length() != 0) {
                    queryString.append(" and (@gender ").append("= '").append(gender).append("')");
                } else {
                    queryString.append(" @gender ").append("= '").append(gender).append("'");
                }
            }
            if (position.length() != 0 || gender.length() != 0) {
                queryString.append("]");
            }
            Query query1 = queryManager.createQuery(queryString.toString(), "xpath");
            QueryResult queryResult = query1.execute();
            nodeIterator = queryResult.getNodes();
        }
        catch (Exception e) {
            LOG.warn((Object)("error while filtering identities: " + e.getMessage()));
            ArrayList<Identity> queryString = new ArrayList<Identity>();
            return queryString;
        }
        finally {
            this.sessionManager.closeSession();
        }
        Node profileNode = null;
        Node identityNode = null;
        Identity identity = null;
        String fullUserName = null;
        String fullNameLC = null;
        String userNameLC = null;
        while (nodeIterator.hasNext()) {
            profileNode = (Node)nodeIterator.next();
            identityNode = profileNode.getProperty(PROFILE_IDENTITY).getNode();
            identity = this.getIdentity(identityNode);
            if (userName.length() != 0) {
                fullUserName = identity.getProfile().getFullName();
                fullNameLC = fullUserName.toLowerCase();
                userNameLC = userName.toLowerCase();
                if (userNameLC.length() == 0 || !fullNameLC.matches(userNameLC)) continue;
                listIdentity.add(identity);
                continue;
            }
            listIdentity.add(identity);
        }
        return listIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getIdentitiesFilterByAlphaBet(String identityProvider, ProfileFiler profileFilter) throws Exception {
        Session session = this.sessionManager.openSession();
        Node profileHomeNode = this.getProfileServiceHome(session);
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        NodeIterator nodeIterator = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/").append(profileHomeNode.getPath()).append("/").append(PROFILE_NODETYPE);
            String userName = profileFilter.getName();
            if (userName.length() != 0) {
                queryString.append("[");
            }
            if (userName.length() != 0) {
                userName = userName + "*";
                queryString.append("(jcr:contains(@firstName, ").append("'").append(userName).append("'))");
            }
            if (userName.length() != 0) {
                queryString.append("]");
            }
            Query query1 = queryManager.createQuery(queryString.toString(), "xpath");
            QueryResult queryResult = query1.execute();
            nodeIterator = queryResult.getNodes();
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to filter identities by alphabet" + e.getMessage()));
            List<Identity> queryString = null;
            return queryString;
        }
        finally {
            this.sessionManager.closeSession();
        }
        while (nodeIterator.hasNext()) {
            Node profileNode = (Node)nodeIterator.next();
            Node identityNode = profileNode.getProperty(PROFILE_IDENTITY).getNode();
            listIdentity.add(this.getIdentity(identityNode));
        }
        return listIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProfile(Profile p) throws Exception {
        try {
            Node profileNode;
            Session session = this.sessionManager.openSession();
            Node profileHomeNode = this.getProfileServiceHome(session);
            if (p.getIdentity().getId() == null) {
                throw new Exception("the identity has to be saved before saving the profile");
            }
            if (p.getId() == null) {
                profileNode = profileHomeNode.addNode(PROFILE_NODETYPE, PROFILE_NODETYPE);
                profileNode.addMixin("mix:referenceable");
                Node identityNode = session.getNodeByUUID(p.getIdentity().getId());
                profileNode.setProperty(PROFILE_IDENTITY, identityNode);
            } else {
                profileNode = session.getNodeByUUID(p.getId());
            }
            this.saveProfile(p, profileNode, session);
            if (p.getId() == null) {
                LOG.debug((Object)"About to create a new profile...");
                profileHomeNode.save();
                p.setId(profileNode.getUUID());
            } else {
                profileNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to save profile " + p), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    protected void saveProfile(Profile p, Node n, Session session) throws Exception, IOException {
        Map<String, Object> props = p.getProperties();
        Iterator<String> it = props.keySet().iterator();
        for (String name : props.keySet()) {
            if (name.contains(":")) continue;
            String[] propValue = props.get(name);
            if (this.isForcedMultiValue(name)) {
                if (propValue instanceof String) {
                    String[] arr = new String[]{(String)propValue};
                    propValue = arr;
                }
                this.setProperty(name, propValue, n);
                continue;
            }
            if (propValue instanceof String) {
                n.setProperty(name, (String)propValue);
                continue;
            }
            if (propValue instanceof Double) {
                n.setProperty(name, ((Double)propValue).doubleValue());
                continue;
            }
            if (propValue instanceof Boolean) {
                n.setProperty(name, ((Boolean)propValue).booleanValue());
                continue;
            }
            if (propValue instanceof Long) {
                n.setProperty(name, ((Long)propValue).longValue());
                continue;
            }
            if (propValue instanceof String[] && propValue.length == 1) {
                n.setProperty(name, propValue[0]);
                continue;
            }
            if (propValue instanceof String[]) {
                this.setProperty(name, propValue, n);
                continue;
            }
            if (propValue instanceof List) {
                this.setProperty(name, (List)propValue, n);
                continue;
            }
            if (!(propValue instanceof ProfileAttachment)) continue;
            ExtendedNode extNode = (ExtendedNode)n;
            if (extNode.canAddMixin("exo:privilegeable")) {
                extNode.addMixin("exo:privilegeable");
            }
            String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
            extNode.setPermission(SystemIdentity.ANY, arrayPers);
            List permsList = extNode.getACL().getPermissionEntries();
            for (AccessControlEntry accessControlEntry : permsList) {
                extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
            }
            ProfileAttachment profileAtt = (ProfileAttachment)propValue;
            if (profileAtt.getFileName() != null) {
                Node nodeFile = null;
                try {
                    nodeFile = n.getNode(name);
                }
                catch (PathNotFoundException ex) {
                    nodeFile = n.addNode(name, "nt:file");
                }
                Node nodeContent = null;
                try {
                    nodeContent = nodeFile.getNode("jcr:content");
                }
                catch (PathNotFoundException ex) {
                    nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
                }
                long lastModified = profileAtt.getLastModified();
                long lastSaveTime = 0L;
                if (nodeContent.hasProperty("jcr:lastModified")) {
                    lastSaveTime = nodeContent.getProperty("jcr:lastModified").getLong();
                }
                if (lastModified == 0L || lastModified == lastSaveTime) continue;
                nodeContent.setProperty("jcr:mimeType", profileAtt.getMimeType());
                nodeContent.setProperty("jcr:data", profileAtt.getInputStream(session));
                nodeContent.setProperty("jcr:lastModified", profileAtt.getLastModified());
                continue;
            }
            if (!n.hasNode(name)) continue;
            n.getNode(name).remove();
            session.save();
        }
    }

    private void setProperty(String name, List<Map<String, Object>> props, Node n) throws Exception, ConstraintViolationException, VersionException {
        String ntName = this.getNodeTypeName(name);
        if (ntName == null) {
            throw new Exception("no nodeType is defined for " + name);
        }
        NodeIterator nIt = n.getNodes(name);
        while (nIt.hasNext()) {
            Node currNode = nIt.nextNode();
            currNode.remove();
        }
        for (Map<String, Object> prop : props) {
            Node propNode = n.addNode(name, ntName);
            for (String key : prop.keySet()) {
                Object propValue = prop.get(key);
                if (propValue instanceof String) {
                    propNode.setProperty(key, (String)propValue);
                    continue;
                }
                if (propValue instanceof Double) {
                    propNode.setProperty(key, ((Double)propValue).doubleValue());
                    continue;
                }
                if (propValue instanceof Boolean) {
                    propNode.setProperty(key, ((Boolean)propValue).booleanValue());
                    continue;
                }
                if (!(propValue instanceof Long)) continue;
                propNode.setProperty(key, ((Long)propValue).longValue());
            }
        }
    }

    private void setProperty(String name, String[] propValue, Node n) throws IOException, RepositoryException, ConstraintViolationException, VersionException {
        ArrayList<StringValue> values = new ArrayList<StringValue>();
        for (String value : propValue) {
            if (value == null || value.length() <= 0) continue;
            values.add(new StringValue(value));
        }
        n.setProperty(name, values.toArray(new Value[values.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProfile(Profile p) throws Exception {
        if (p.getIdentity().getId() == null) {
            throw new Exception("the identity has to be saved before loading the profile");
        }
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node idNode = session.getNodeByUUID(p.getIdentity().getId());
            PropertyIterator it = idNode.getReferences();
            while (it.hasNext()) {
                Property prop = (Property)it.next();
                if (!prop.getParent().isNodeType(PROFILE_NODETYPE)) continue;
                Node n = prop.getParent();
                p.setId(n.getUUID());
                this.loadProfile(p, n, session);
                return;
            }
            if (it.getSize() < 1L) {
                Node profileNode;
                LOG.debug((Object)"Lazily initializing a new Profile...");
                Node profileHomeNode = this.getProfileServiceHome(session);
                if (p.getId() == null) {
                    profileNode = profileHomeNode.addNode(PROFILE_NODETYPE, PROFILE_NODETYPE);
                    profileNode.addMixin("mix:referenceable");
                    Node identityNode = session.getNodeByUUID(p.getIdentity().getId());
                    profileNode.setProperty(PROFILE_IDENTITY, identityNode);
                } else {
                    profileNode = session.getNodeByUUID(p.getId());
                }
                this.saveProfile(p, profileNode, session);
                if (p.getId() == null) {
                    profileHomeNode.save();
                    p.setId(profileNode.getUUID());
                } else {
                    profileNode.save();
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to load Profile " + p), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    protected boolean isForcedMultiValue(String key) {
        return this.getConfig().isForcedMultiValue(key);
    }

    protected String getNodeTypeName(String nodeName) {
        return this.getConfig().getNodeType(nodeName);
    }

    protected void loadProfile(Profile p, Node n, Session session) throws RepositoryException {
        PropertyIterator props = n.getProperties();
        this.copyPropertiesToMap(props, p.getProperties());
        NodeIterator it = n.getNodes();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (node.getName().equals(PROFILE_AVATAR)) {
                if (!node.isNodeType("nt:file")) continue;
                ProfileAttachment file = new ProfileAttachment();
                file.setId(node.getPath());
                file.setMimeType(node.getNode("jcr:content").getProperty("jcr:mimeType").getString());
                try {
                    file.setInputStream(node.getNode("jcr:content").getProperty("jcr:data").getValue().getStream());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to load data for avatar of " + p + ": " + e.getMessage()));
                }
                file.setLastModified(node.getNode("jcr:content").getProperty("jcr:lastModified").getLong());
                file.setFileName(node.getName());
                file.setWorkspace(session.getWorkspace().getName());
                p.setProperty(node.getName(), file);
                continue;
            }
            List l = (List)p.getProperty(node.getName());
            if (l == null) {
                p.setProperty(node.getName(), new ArrayList());
                l = (List)p.getProperty(node.getName());
            }
            l.add(this.copyPropertiesToMap(node.getProperties(), new HashMap()));
        }
    }

    private Map copyPropertiesToMap(PropertyIterator props, Map map) throws RepositoryException {
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            if (prop.getName().contains(":")) continue;
            try {
                Value v = prop.getValue();
                if (v instanceof StringValue) {
                    map.put(prop.getName(), v.getString());
                    continue;
                }
                if (v instanceof LongValue) {
                    map.put(prop.getName(), v.getLong());
                    continue;
                }
                if (v instanceof DoubleValue) {
                    map.put(prop.getName(), v.getDouble());
                    continue;
                }
                if (!(v instanceof BooleanValue)) continue;
                map.put(prop.getName(), v.getBoolean());
            }
            catch (ValueFormatException e) {
                Value[] values = prop.getValues();
                ArrayList<String> res = new ArrayList<String>();
                for (Value v : values) {
                    res.add(v.getString());
                }
                map.put(prop.getName(), res.toArray(new String[res.size()]));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType(String nodetype, String property) throws Exception {
        try {
            PropertyDefinition[] pDefs;
            Session session = this.sessionManager.openSession();
            NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
            NodeType nt = ntManager.getNodeType(nodetype);
            for (PropertyDefinition pDef : pDefs = nt.getDeclaredPropertyDefinitions()) {
                if (!pDef.getName().equals(property)) continue;
                String string = PropertyType.nameFromValue((int)pDef.getRequiredType());
                return string;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Could not find type of property " + property + " for nodetype " + nodetype));
            String string = null;
            return string;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }
}

