/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.IdentityProviderPlugin;
import org.exoplatform.social.core.identity.JCRStorage;
import org.exoplatform.social.core.identity.ProfileFiler;
import org.exoplatform.social.core.identity.lifecycle.ProfileLifeCycle;
import org.exoplatform.social.core.identity.lifecycle.ProfileListenerPlugin;
import org.exoplatform.social.core.identity.model.GlobalId;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.spi.ProfileListener;
import org.exoplatform.social.jcr.SocialDataLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityManager {
    private static final Log LOG = ExoLogger.getExoLogger(IdentityManager.class);
    private Map<String, IdentityProvider<?>> identityProviders = new HashMap();
    private JCRStorage identityStorage;
    private ProfileLifeCycle profileLifeCycle = new ProfileLifeCycle();

    public IdentityManager(SocialDataLocation dataLocation, IdentityProvider<?> defaultIdentityProvider) throws Exception {
        this.identityStorage = new JCRStorage(dataLocation);
        this.addIdentityProvider(defaultIdentityProvider);
    }

    public void registerIdentityProviders(IdentityProviderPlugin plugin) {
        List<IdentityProvider<?>> pluginProviders = plugin.getProviders();
        if (pluginProviders != null) {
            for (IdentityProvider<?> identityProvider : pluginProviders) {
                this.addIdentityProvider(identityProvider);
            }
        }
    }

    public Identity getIdentity(String id) throws Exception {
        return this.getIdentity(id, true);
    }

    public Identity getIdentity(String id, boolean loadProfile) throws Exception {
        Identity identity = null;
        if (GlobalId.isValid(id)) {
            GlobalId globalId = new GlobalId(id);
            String providerId = globalId.getDomain();
            String remoteId = globalId.getLocalId();
            identity = this.getOrCreateIdentity(providerId, remoteId, loadProfile);
        }
        if (identity == null) {
            identity = this.identityStorage.findIdentityById(id);
        }
        if (identity == null) {
            return null;
        }
        if (loadProfile) {
            this.identityStorage.loadProfile(identity.getProfile());
        }
        return identity;
    }

    public void addIdentityProvider(IdentityProvider<?> idProvider) {
        if (idProvider != null) {
            LOG.debug((Object)("Registering identity provider for " + idProvider.getName() + ": " + idProvider));
            this.identityProviders.put(idProvider.getName(), idProvider);
        }
    }

    public Identity getOrCreateIdentity(String providerId, String remoteId) throws Exception {
        return this.getOrCreateIdentity(providerId, remoteId, true);
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFiler profileFilter) throws Exception {
        return this.identityStorage.getIdentitiesByProfileFilter(providerId, profileFilter);
    }

    public List<Identity> getIdentitiesByProfileFilter(ProfileFiler profileFilter) throws Exception {
        return this.getIdentitiesByProfileFilter(null, profileFilter);
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFiler profileFilter) throws Exception {
        return this.identityStorage.getIdentitiesFilterByAlphaBet(providerId, profileFilter);
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(ProfileFiler profileFilter) throws Exception {
        return this.getIdentitiesFilterByAlphaBet(null, profileFilter);
    }

    public Identity getOrCreateIdentity(String providerId, String remoteId, boolean loadProfile) throws Exception {
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        Identity identity1 = identityProvider.getIdentityByRemoteId(remoteId);
        Identity result = this.identityStorage.findIdentity(providerId, remoteId);
        if (result == null) {
            if (identity1 != null) {
                this.saveIdentity(identity1);
                this.identityStorage.saveProfile(identity1.getProfile());
                result = identity1;
            }
        } else if (loadProfile) {
            this.identityStorage.loadProfile(result.getProfile());
        }
        return result;
    }

    public Identity getIdentity(String providerId, String remoteId, boolean loadProfile) throws Exception {
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        Identity identity = identityProvider.getIdentityByRemoteId(remoteId);
        if (identity == null) {
            return null;
        }
        if (loadProfile) {
            this.identityStorage.loadProfile(identity.getProfile());
        }
        return identity;
    }

    public boolean identityExisted(String providerId, String remoteId) {
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        return identityProvider.getIdentityByRemoteId(remoteId) != null;
    }

    public void saveIdentity(Identity identity) throws Exception {
        this.identityStorage.saveIdentity(identity);
        this.getIdentityProvider(identity.getProviderId()).onSaveIdentity(identity);
    }

    public void updateAvatar(Profile p) throws Exception {
        this.identityStorage.saveProfile(p);
        this.profileLifeCycle.avatarUpdated(p.getIdentity().getRemoteId(), p);
    }

    public void updateBasicInfo(Profile p) throws Exception {
        this.identityStorage.saveProfile(p);
        this.profileLifeCycle.basicUpdated(p.getIdentity().getRemoteId(), p);
    }

    public void updateContactSection(Profile p) throws Exception {
        this.identityStorage.saveProfile(p);
        this.profileLifeCycle.contactUpdated(p.getIdentity().getRemoteId(), p);
    }

    public void updateExperienceSection(Profile p) throws Exception {
        this.identityStorage.saveProfile(p);
        this.profileLifeCycle.experienceUpdated(p.getIdentity().getRemoteId(), p);
    }

    public void updateHeaderSection(Profile p) throws Exception {
        this.identityStorage.saveProfile(p);
        this.profileLifeCycle.headerUpdated(p.getIdentity().getRemoteId(), p);
    }

    public List<Identity> getIdentities(String providerId) throws Exception {
        return this.getIdentities(providerId, true);
    }

    public List<Identity> getIdentities(String providerId, boolean loadProfile) throws Exception {
        IdentityProvider<?> ip = this.getIdentityProvider(providerId);
        List<String> userids = ip.getAllUserId();
        ArrayList<Identity> ids = new ArrayList<Identity>();
        for (String userId : userids) {
            ids.add(this.getOrCreateIdentity(providerId, userId, loadProfile));
        }
        return ids;
    }

    protected JCRStorage getStorage() {
        return this.identityStorage;
    }

    public void setIdentityStorage(JCRStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    private IdentityProvider<?> getIdentityProvider(String providerId) {
        IdentityProvider<?> provider = this.identityProviders.get(providerId);
        if (provider == null) {
            throw new RuntimeException("No suitable identity provider exists for " + providerId);
        }
        return provider;
    }

    public void registerProfileListener(ProfileListener listener) {
        this.profileLifeCycle.addListener(listener);
    }

    public void unregisterProfileListener(ProfileListener listener) {
        this.profileLifeCycle.removeListener(listener);
    }

    public void addProfileListener(ProfileListenerPlugin plugin) {
        this.registerProfileListener(plugin);
    }

    public JCRStorage getIdentityStorage() {
        return this.identityStorage;
    }
}

