/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api.models;

import java.util.HashMap;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.ProfileRest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityRest
extends HashMap<String, Object> {
    private static final long serialVersionUID = 4373990937109717268L;
    public static final String ID = "id";
    public static final String REMOTE_ID = "remoteId";
    public static final String PROVIDER_ID = "providerId";
    public static final String PROFILE = "profile";

    public IdentityRest() {
    }

    public IdentityRest(String identityId) {
        IdentityManager identityManager = Util.getIdentityManager();
        Identity identity = identityManager.getIdentity(identityId, false);
        this.put(ID, identity.getId());
        this.put(REMOTE_ID, identity.getRemoteId());
        this.put(PROVIDER_ID, identity.getProviderId());
        this.put(PROFILE, new ProfileRest(identity.getProfile()));
    }

    public IdentityRest(Identity identity) {
        this.setId(identity.getId());
        this.setRemoteId(identity.getRemoteId());
        this.setProviderId(identity.getProviderId());
        this.setProfile(new ProfileRest(identity.getProfile()));
    }

    public String getId() {
        return (String)this.get(ID);
    }

    public void setId(String id) {
        if (id != null) {
            this.put(ID, id);
        }
    }

    public String getRemoteId() {
        return (String)this.get(REMOTE_ID);
    }

    public void setRemoteId(String remoteId) {
        if (remoteId != null) {
            this.put(REMOTE_ID, remoteId);
        }
    }

    public String getProviderId() {
        return (String)this.get(PROVIDER_ID);
    }

    public void setProviderId(String providerId) {
        if (providerId != null) {
            this.put(PROVIDER_ID, providerId);
        }
    }

    public void setProfile(ProfileRest profile) {
        if (profile != null) {
            this.put(PROFILE, profile);
        }
    }

    public ProfileRest getProfile() {
        return (ProfileRest)this.get(PROFILE);
    }
}

