/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api_v1alpha1;

import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.Util;

@Path(value="api/social/v1-alpha1/{portalContainerName}/identity/")
public class IdentityResources
implements ResourceContainer {
    private static final String[] SUPPORTED_FORMAT = new String[]{"json"};
    private IdentityManager identityManager;

    @GET
    @Path(value="{identityId}.{format}")
    public Response getIdentityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="format") String format) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (identityId != null && !identityId.equals("")) {
            PortalContainer portalContainer = this.getPortalContainer(portalContainerName);
            this.identityManager = Util.getIdentityManager();
            Identity authenticatedUserIdentity = this.authenticatedUserIdentity();
            Identity identity = this.identityManager.getIdentity(identityId, true);
            if (authenticatedUserIdentity != null) {
                if (portalContainer != null && identity != null) {
                    HashMap<String, Object> resultHashMap = new HashMap<String, Object>();
                    HashMap<String, String> resultProfileHashMap = new HashMap<String, String>();
                    resultHashMap.put("id", identity.getId());
                    resultHashMap.put("providerId", identity.getProviderId());
                    resultHashMap.put("remoteId", identity.getRemoteId());
                    Profile profile = identity.getProfile();
                    resultProfileHashMap.put("fullName", profile.getFullName());
                    resultProfileHashMap.put("avatarUrl", profile.getAvatarUrl());
                    resultHashMap.put("profile", resultProfileHashMap);
                    return Util.getResponse(resultHashMap, uriInfo, mediaType, Response.Status.OK);
                }
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    private Identity authenticatedUserIdentity() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && ConversationState.getCurrent().getIdentity().getUserId() != null) {
            IdentityManager identityManager = Util.getIdentityManager();
            String authenticatedUserRemoteID = ConversationState.getCurrent().getIdentity().getUserId();
            return identityManager.getOrCreateIdentity("organization", authenticatedUserRemoteID, false);
        }
        return null;
    }

    private PortalContainer getPortalContainer(String name) {
        return (PortalContainer)ExoContainerContext.getContainerByName((String)name);
    }
}

