/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.api.models.IdentityRestOut;
import org.exoplatform.social.service.rest.api.models.ProfileRestOut;

public final class Util {
    private Util() {
    }

    public static Response getResponse(Object entity, UriInfo uriInfo, MediaType mediaType, Response.Status status) {
        return Response.created((URI)UriBuilder.fromUri((URI)uriInfo.getAbsolutePath()).build(new Object[0])).entity(entity).type(mediaType).status(status).build();
    }

    @Deprecated
    public static MediaType getMediaType(String format) throws WebApplicationException {
        if (format.equals("json")) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        if (format.equals("xml")) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    public static MediaType getMediaType(String expectedFormat, String[] supportedFormats) {
        if (!Util.isSupportedFormat(expectedFormat, supportedFormats)) {
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        if (expectedFormat.equals("json") && Util.isSupportedFormat("json", supportedFormats)) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        if (expectedFormat.equals("xml") && Util.isSupportedFormat("xml", supportedFormats)) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        if (expectedFormat.equals("atom") && Util.isSupportedFormat("atom", supportedFormats)) {
            return MediaType.APPLICATION_ATOM_XML_TYPE;
        }
        throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
    }

    public static String getViewerId(UriInfo uriInfo) {
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        String[] queryParts = requestString.split("&");
        String viewerId = null;
        for (String queryPart : queryParts) {
            if (!queryPart.startsWith("opensocial_viewer_id")) continue;
            viewerId = queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
            break;
        }
        return viewerId;
    }

    @Deprecated
    public static Identity getViewerIdentity(String viewerId) {
        return Util.getUserIdentity(viewerId, false);
    }

    public static Identity getViewerIdentity(String portalContainerName, String viewerId) {
        return Util.getUserIdentity(portalContainerName, viewerId, false);
    }

    @Deprecated
    public static Identity getUserIdentity(String userName, boolean loadProfile) {
        return Util.getIdentityManager().getOrCreateIdentity("organization", userName, loadProfile);
    }

    public static Identity getUserIdentity(String portalContainerName, String userName, boolean loadProfile) {
        return Util.getIdentityManager(portalContainerName).getOrCreateIdentity("organization", userName, loadProfile);
    }

    @Deprecated
    public static final IdentityManager getIdentityManager() {
        return (IdentityManager)Util.getDefaultPortalContainer().getComponentInstanceOfType(IdentityManager.class);
    }

    public static final IdentityManager getIdentityManager(String portalContainerName) {
        return (IdentityManager)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(IdentityManager.class);
    }

    @Deprecated
    public static final SpaceService getSpaceService() {
        return (SpaceService)Util.getDefaultPortalContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public static final SpaceService getSpaceService(String portalContainerName) {
        return (SpaceService)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(SpaceService.class);
    }

    @Deprecated
    public static final ActivityManager getActivityManager() {
        return (ActivityManager)Util.getDefaultPortalContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    public static final ActivityManager getActivityManager(String portalContainerName) {
        return (ActivityManager)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(ActivityManager.class);
    }

    @Deprecated
    public static final RelationshipManager getRelationshipManager() {
        return (RelationshipManager)Util.getDefaultPortalContainer().getComponentInstanceOfType(RelationshipManager.class);
    }

    public static final RelationshipManager getRelationshipManager(String portalContainerName) {
        return (RelationshipManager)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(RelationshipManager.class);
    }

    public static final PortalContainer getPortalContainerByName(String portalContainerName) {
        return (PortalContainer)ExoContainerContext.getContainerByName((String)portalContainerName);
    }

    public static final String convertTimestampToTimeString(long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss Z yyyy");
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(new Date(timestamp));
    }

    @Deprecated
    public static Identity getOwnerIdentityIdFromActivity(ExoSocialActivity activity) {
        IdentityManager identityManager = Util.getIdentityManager();
        ActivityStream activityStream = activity.getActivityStream();
        ActivityStream.Type activityType = activityStream.getType();
        String name = activity.getStreamOwner();
        if (activityType.equals((Object)ActivityStream.Type.USER)) {
            return identityManager.getOrCreateIdentity("organization", name, false);
        }
        return identityManager.getOrCreateIdentity("space", name, false);
    }

    public static Identity getOwnerIdentityIdFromActivity(String portalContainerName, ExoSocialActivity activity) {
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        ActivityStream activityStream = activity.getActivityStream();
        ActivityStream.Type activityType = activityStream.getType();
        String name = activity.getStreamOwner();
        if (activityType.equals((Object)ActivityStream.Type.USER)) {
            return identityManager.getOrCreateIdentity("organization", name, false);
        }
        return identityManager.getOrCreateIdentity("space", name, false);
    }

    public static final String getBaseUrl() {
        HttpServletRequest currentServletRequest = Util.getCurrentServletRequest();
        return currentServletRequest.getScheme() + "://" + currentServletRequest.getServerName() + ":" + currentServletRequest.getServerPort();
    }

    private static HttpServletRequest getCurrentServletRequest() {
        EnvironmentContext environmentContext = EnvironmentContext.getCurrent();
        return (HttpServletRequest)environmentContext.get(HttpServletRequest.class);
    }

    private static boolean isSupportedFormat(String expectedFormat, String[] supportedFormats) {
        for (String supportedFormat : supportedFormats) {
            if (!supportedFormat.equals(expectedFormat)) continue;
            return true;
        }
        return false;
    }

    private static PortalContainer getDefaultPortalContainer() {
        return PortalContainer.getInstance();
    }

    public static void buildAbsoluteAvatarURL(IdentityRestOut resultIdentity) {
        if (resultIdentity.getProfile() != null && resultIdentity.getProviderId() != null) {
            ProfileRestOut resultProfile = resultIdentity.getProfile();
            if (resultProfile.getAvatarUrl() == null || resultProfile.getAvatarUrl().trim().equals("")) {
                if (resultIdentity.getProviderId().equals("space")) {
                    resultProfile.setAvatarUrl(Util.getBaseUrl() + "/social-resources/skin/ShareImages/SpaceImages/SpaceLogoDefault_61x61.gif");
                } else {
                    resultProfile.setAvatarUrl(Util.getBaseUrl() + "/social-resources/skin/ShareImages/Avatar.gif");
                }
            } else if (!resultProfile.getAvatarUrl().startsWith("http://") && !resultProfile.getAvatarUrl().startsWith("https://")) {
                resultProfile.setAvatarUrl(Util.getBaseUrl() + resultProfile.getAvatarUrl());
            }
        }
    }

    public static Identity getAuthenticatedUserIdentity(String portalContainerName) {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && ConversationState.getCurrent().getIdentity().getUserId() != null) {
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
            String authenticatedUserRemoteID = ConversationState.getCurrent().getIdentity().getUserId();
            return identityManager.getOrCreateIdentity("organization", authenticatedUserRemoteID, false);
        }
        return null;
    }

    public static boolean isLikedByIdentity(String identityID, ExoSocialActivity activity) {
        String[] likedIdentityIds = activity.getLikeIdentityIds();
        if (activity.getLikeIdentityIds() != null && likedIdentityIds.length > 0) {
            for (int i = 0; i < likedIdentityIds.length; ++i) {
                if (!identityID.equals(likedIdentityIds[i])) continue;
                return true;
            }
        }
        return false;
    }
}

