/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.application.impl;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIControlWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.social.application.SpaceApplicationHandler;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSpaceApplicationHandler
implements SpaceApplicationHandler {
    public static final String NAME = "classic";
    private ExoContainer container = ExoContainerContext.getCurrentContainer();
    private UserPortalConfigService configService = (UserPortalConfigService)this.container.getComponentInstanceOfType(UserPortalConfigService.class);

    @Override
    public void activateApplication(Space space, String appId) throws SpaceException {
        this.activeApplicationClassic(space, appId);
    }

    @Override
    public void deactiveApplication(Space space, String appId) throws SpaceException {
        this.deactiveApplicationClassic(space, appId);
    }

    @Override
    public void initSpace(Space space) throws SpaceException {
        try {
            String tempPageId = "group::platform/user::dashboard";
            String newPageName = space.getShortName();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            UserPortalConfigService dataService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
            PageNavigation spaceNav = new PageNavigation();
            spaceNav.setOwnerType("group");
            spaceNav.setOwnerId(space.getGroupId().substring(1));
            spaceNav.setModifiable(true);
            dataService.create(spaceNav);
            UIPortal uiPortal = Util.getUIPortal();
            List pnavigations = uiPortal.getNavigations();
            SpaceUtils.setNavigation(pnavigations, spaceNav);
            pnavigations.add(spaceNav);
            PageNode node = dataService.createNodeFromPageTemplate(newPageName, newPageName, tempPageId, "group", space.getShortName(), null);
            node.setUri(space.getShortName());
            spaceNav.addNode(node);
            dataService.update(spaceNav);
            SpaceUtils.setNavigation(uiPortal.getNavigations(), spaceNav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREAT_NAV, (Throwable)e);
        }
    }

    @Override
    public void installApplication(Space space, String appId) throws SpaceException {
    }

    @Override
    public void removeApplication(Space space, String appId) throws SpaceException {
        this.removeApplicationClassic(space, appId);
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void activeApplicationClassic(Space space, String appId) throws SpaceException {
        PageNavigation nav;
        List<Application> apps;
        try {
            apps = SpaceUtils.getAllApplications(space.getId());
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_LIST_AVAILABLE_APPLICATIONS, (Throwable)e);
        }
        String spaceNav = space.getGroupId().substring(1);
        Page page = new Page();
        page.setOwnerType("group");
        page.setOwnerId(spaceNav);
        page.setName(appId);
        page.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
        page.setEditPermission("manager:" + space.getGroupId());
        page.setModifiable(true);
        Application app = this.getApplication(apps, appId);
        org.exoplatform.portal.config.model.Application child = new org.exoplatform.portal.config.model.Application();
        StringBuilder windowId = new StringBuilder();
        windowId.append("portal");
        windowId.append("#classic:/");
        windowId.append(app.getApplicationGroup() + "/" + app.getApplicationName()).append("/");
        windowId.append(app.hashCode());
        child.setInstanceId(windowId.toString());
        child.setTitle(app.getDisplayName());
        ArrayList<org.exoplatform.portal.config.model.Application> applications = new ArrayList<org.exoplatform.portal.config.model.Application>();
        applications.add(child);
        page.setChildren(applications);
        try {
            this.configService.create(page);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_APPLICATION, (Throwable)e);
        }
        try {
            PageNode pageNode = new PageNode();
            pageNode.setUri(app.getApplicationName());
            pageNode.setName(app.getApplicationName());
            pageNode.setLabel(app.getDisplayName());
            pageNode.setPageReference(page.getPageId());
            nav = this.configService.getPageNavigation("group", spaceNav);
            PageNode homeNode = nav.getNode(space.getShortName());
            ArrayList<PageNode> childNodes = homeNode.getChildren();
            if (childNodes == null) {
                childNodes = new ArrayList<PageNode>();
            }
            childNodes.add(pageNode);
            homeNode.setChildren(childNodes);
            this.configService.update(nav);
        }
        catch (Exception e) {
            try {
                this.configService.remove(page);
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_APPLICATION, (Throwable)e);
        }
        this.updateNavigationPortlet(nav);
    }

    private void updateNavigationPortlet(PageNavigation nav) {
        UIPortal uiPortal = Util.getUIPortal();
        SpaceUtils.setNavigation(uiPortal.getNavigations(), nav);
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
        UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.getChildById("UIControlWorkspace");
        if (uiControl != null) {
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiControl);
        }
    }

    private void deactiveApplicationClassic(Space space, String appId) {
    }

    private void removeApplicationClassic(Space space, String appId) throws SpaceException {
        try {
            String spaceNav = space.getGroupId().substring(1);
            PageNavigation nav = this.configService.getPageNavigation("group", spaceNav);
            PageNode homeNode = nav.getNode(space.getShortName());
            List childNodes = homeNode.getChildren();
            childNodes.remove(homeNode.getChild(appId));
            homeNode.setChildren((ArrayList)childNodes);
            this.configService.update(nav);
            Page page = this.configService.getPage("group::" + spaceNav + "::" + appId);
            this.configService.remove(page);
            UIPortal uiPortal = Util.getUIPortal();
            SpaceUtils.setNavigation(uiPortal.getNavigations(), nav);
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.getChildById("UIControlWorkspace");
            if (uiControl != null) {
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiControl);
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATION, (Throwable)e);
        }
    }

    private Application getApplication(List<Application> apps, String appId) {
        for (Application app : apps) {
            if (!app.getApplicationName().equals(appId)) continue;
            return app;
        }
        return null;
    }
}

