/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static List sort(List l, String key1, String key2, boolean reverse) {
        if (l == null) {
            return null;
        }
        Collections.sort(l, new MapSorter(key1, key2));
        if (reverse) {
            Collections.reverse(l);
        }
        return l;
    }

    public static List sort(List l, String key1, String key2) {
        return Utils.sort(l, key1, key2, false);
    }

    public static List sort(List l, String key) {
        return Utils.sort(l, key, null, false);
    }

    private static Object select(List<Map> l, String key, String value, boolean onlyFirst) {
        ArrayList<Map> res = new ArrayList<Map>();
        for (Map m : l) {
            if (!m.containsKey(key) || !m.get(key).equals(value)) continue;
            if (onlyFirst) {
                return m;
            }
            res.add(m);
        }
        return res;
    }

    public static List select(List<Map> l, String key, String value) {
        return (List)Utils.select(l, key, value, false);
    }

    public static Map selectFirst(List<Map> l, String key, String value) {
        return (Map)Utils.select(l, key, value, true);
    }

    public static Identity getCurrentIdentity() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        if (URLUtils.getCurrentUser() != null) {
            currentUserName = URLUtils.getCurrentUser();
        }
        return identityManager.getOrCreateIdentity("organization", currentUserName);
    }

    protected static class MapSorter
    implements Comparator {
        private String key1;
        private String key2;

        public MapSorter(String key1, String key2) {
            this.key1 = key1;
            this.key2 = key2;
        }

        public int compare(Object o1, Object o2) {
            int res = this.compare(o1, o2, this.key1);
            if (res == 0 && this.key2 != null) {
                res = this.compare(o1, o2, this.key2);
            }
            return res;
        }

        public int compare(Object o1, Object o2, String key) {
            HashMap h1 = null;
            HashMap h2 = null;
            if (o1 instanceof HashMap) {
                h1 = (HashMap)o1;
            }
            if (o2 instanceof HashMap) {
                h2 = (HashMap)o2;
            }
            if (h1 == null && h2 == null) {
                return 0;
            }
            if (h1 == null) {
                return -1;
            }
            if (h2 == null) {
                return 1;
            }
            if (!h1.containsKey(key) && !h2.containsKey(key)) {
                return 0;
            }
            if (!h1.containsKey(key)) {
                return -1;
            }
            if (!h2.containsKey(key)) {
                return 1;
            }
            Object v1 = h1.get(key);
            Object v2 = h2.get(key);
            if (v1 instanceof String) {
                return ((String)v1).compareToIgnoreCase((String)v2);
            }
            return ((Comparable)v1).compareTo(v2);
        }
    }
}

