/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import org.apache.commons.lang.Validate;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.activity.UserActivityListAccess;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/social/webui/profile/UIUserActivitiesDisplay.gtmpl", events={@EventConfig(listeners={ChangeDisplayModeActionListener.class})})
public class UIUserActivitiesDisplay
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIUserActivitiesDisplay.class);
    private static final int ACTIVITY_PER_PAGE = 10;
    private DisplayMode selectedDisplayMode = DisplayMode.CONNECTIONS;
    private String ownerName;
    private String viewerName;
    private boolean isActivityStreamOwner = false;
    private UIActivitiesContainer uiActivitiesContainer;
    private UIPageIterator pageIterator;

    public boolean isActivityStreamOwner() {
        return this.isActivityStreamOwner;
    }

    public void setSelectedDisplayMode(DisplayMode displayMode) {
        this.selectedDisplayMode = displayMode;
        try {
            this.init();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to init()");
        }
    }

    public DisplayMode getSelectedDisplayMode() {
        return this.selectedDisplayMode;
    }

    public void setOwnerName(String ownerName) throws Exception {
        this.ownerName = ownerName;
        this.viewerName = PortalRequestContext.getCurrentInstance().getRemoteUser();
        this.isActivityStreamOwner = this.viewerName.equals(ownerName);
        if (!this.isActivityStreamOwner) {
            this.selectedDisplayMode = DisplayMode.OWNER_STATUS;
        }
        this.init();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void init() throws Exception {
        Validate.notNull((Object)this.ownerName, (String)"ownerName must not be null.");
        Validate.notNull((Object)this.viewerName, (String)"viewerName must not be null.");
        this.removeChild(UIPageIterator.class);
        this.pageIterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIActivitiesPageIterator");
        this.removeChild(UIActivitiesContainer.class);
        this.uiActivitiesContainer = (UIActivitiesContainer)this.addChild(UIActivitiesContainer.class, null, null);
        this.uiActivitiesContainer.setPostContext(UIComposer.PostContext.USER);
        this.uiActivitiesContainer.setOwnerName(this.ownerName);
    }

    private void bindDataToActivitiesContainer() throws Exception {
        int currentPage = this.pageIterator.getCurrentPage();
        Identity ownerIdentity = this.getIdentityManager().getOrCreateIdentity("organization", this.ownerName);
        LazyPageList pageList = new LazyPageList((ListAccess)new UserActivityListAccess(ownerIdentity, this.getSelectedDisplayMode()), 10);
        this.pageIterator.setPageList((PageList)pageList);
        int pageCount = this.pageIterator.getAvailablePage();
        if (pageCount >= currentPage) {
            this.pageIterator.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.pageIterator.setCurrentPage(currentPage - 1);
        }
        this.uiActivitiesContainer.setActivityList(this.pageIterator.getCurrentPageData());
    }

    private IdentityManager getIdentityManager() {
        return (IdentityManager)this.getApplicationComponent(IdentityManager.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeDisplayModeActionListener
    extends EventListener<UIUserActivitiesDisplay> {
        public void execute(Event<UIUserActivitiesDisplay> event) throws Exception {
            UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String selectedDisplayMode = requestContext.getRequestParameter("objectId");
            if (selectedDisplayMode.equals(DisplayMode.MY_STATUS.toString())) {
                uiUserActivitiesDisplay.setSelectedDisplayMode(DisplayMode.MY_STATUS);
            } else if (selectedDisplayMode.equals(DisplayMode.SPACES.toString())) {
                uiUserActivitiesDisplay.setSelectedDisplayMode(DisplayMode.SPACES);
            } else {
                uiUserActivitiesDisplay.setSelectedDisplayMode(DisplayMode.CONNECTIONS);
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiUserActivitiesDisplay);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayMode {
        CONNECTIONS,
        SPACES,
        MY_STATUS,
        OWNER_STATUS;

    }
}

