/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.social.webui.profile.UIHeaderSection;
import org.exoplatform.social.webui.profile.UIProfile;
import org.exoplatform.social.webui.profile.UIProfileSection;
import org.exoplatform.social.webui.profile.UITitleBar;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIBasicInfoSection.gtmpl", events={@EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIBasicInfoSection
extends UIProfileSection {
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String GENDER = "gender";
    public static final String GENDER_DEFAULT = "Gender";
    public static final String MALE = "male";
    public static final String FEMALE = "female";
    public static final String REGEX_EXPRESSION = "^\\p{L}[\\p{L}\\d._,\\s]+\\p{L}$";
    public static final String INVALID_CHAR_MESSAGE = "UIBasicInfoSection.msg.Invalid-char";

    public UIBasicInfoSection() throws Exception {
        String username = Util.getPortalRequestContext().getRemoteUser();
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        User useraccount = service.getUserHandler().findUserByName(username);
        this.addChild(UITitleBar.class, null, null);
        UIFormStringInput userName = new UIFormStringInput("userName", "userName", username);
        userName.setEditable(false);
        this.addUIFormInput((UIFormInput)userName);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIRST_NAME, FIRST_NAME, useraccount.getFirstName()).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 45}).addValidator(ExpressionValidator.class, new Object[]{REGEX_EXPRESSION, INVALID_CHAR_MESSAGE}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(LAST_NAME, LAST_NAME, useraccount.getLastName()).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 45}).addValidator(ExpressionValidator.class, new Object[]{REGEX_EXPRESSION, INVALID_CHAR_MESSAGE}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("email", "email", useraccount.getEmail()).addValidator(MandatoryValidator.class, new Object[0]).addValidator(EmailAddressValidator.class, new Object[0]));
    }

    public User getViewUser() throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        if (currentViewer != null && currentViewer != currentUserName) {
            OrganizationService orgSer = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            UserHandler userHandler = orgSer.getUserHandler();
            return userHandler.findUserByName(currentViewer);
        }
        ConversationState state = ConversationState.getCurrent();
        return (User)state.getAttribute("UserProfile");
    }

    public List<UIComponent> getChilds() {
        return this.getChildren();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends UIProfileSection.SaveActionListener {
        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIBasicInfoSection uiForm = (UIBasicInfoSection)sect;
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            UIApplication uiApp = context.getUIApplication();
            String userName = (String)uiForm.getUIStringInput("userName").getValue();
            User user = service.getUserHandler().findUserByName(userName);
            String oldEmail = user.getEmail();
            String newEmail = (String)uiForm.getUIStringInput("email").getValue();
            Query query = new Query();
            query.setEmail(newEmail);
            if (service.getUserHandler().findUsers(query).getAll().size() > 0 && !oldEmail.equals(newEmail)) {
                user.setEmail(oldEmail);
                Object[] args = new Object[]{userName};
                uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.email-exist", args));
                return;
            }
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            Profile p = sect.getProfile(true);
            p.setProperty(UIBasicInfoSection.FIRST_NAME, uiForm.getUIStringInput(UIBasicInfoSection.FIRST_NAME).getValue());
            p.setProperty(UIBasicInfoSection.LAST_NAME, uiForm.getUIStringInput(UIBasicInfoSection.LAST_NAME).getValue());
            p.setProperty("username", (Object)newEmail);
            im.updateBasicInfo(p);
            user.setFirstName((String)uiForm.getUIStringInput(UIBasicInfoSection.FIRST_NAME).getValue());
            user.setLastName((String)uiForm.getUIStringInput(UIBasicInfoSection.LAST_NAME).getValue());
            user.setEmail(newEmail);
            uiApp.addMessage(new ApplicationMessage("UIAccountProfiles.msg.update.success", null));
            service.getUserHandler().saveUser(user, true);
            UIProfile uiProfile = (UIProfile)uiForm.getParent();
            context.addUIComponentToUpdateByAjax(uiProfile.getChild(UIHeaderSection.class));
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)Util.getUIPortalApplication().getChild(UIWorkingWorkspace.class);
            uiWorkingWS.updatePortletsByName("profile");
            uiWorkingWS.updatePortletsByName("UserProfileToolBarPortlet");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends UIProfileSection.EditActionListener {
        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIBasicInfoSection uiForm = (UIBasicInfoSection)sect;
            String username = Util.getPortalRequestContext().getRemoteUser();
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            User user = service.getUserHandler().findUserByName(username);
            uiForm.getUIStringInput(UIBasicInfoSection.FIRST_NAME).setValue((Object)user.getFirstName());
            uiForm.getUIStringInput(UIBasicInfoSection.LAST_NAME).setValue((Object)user.getLastName());
            uiForm.getUIStringInput("email").setValue((Object)user.getEmail());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)sect);
        }
    }
}

