/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.RelationshipListAccess;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/connections/UIMyConnections.gtmpl", events={@EventConfig(listeners={RemoveActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIMyConnections
extends UIContainer {
    private final String iteratorIDContact = "UIPageIteratorContact";
    private static final String RELATION_DELETED_INFO = "UIMyRelations.label.DeletedInfo";
    UIPageIterator uiPageIteratorContact = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIPageIteratorContact");
    private RelationshipManager relationshipManager;
    private IdentityManager identityManager = null;
    UIProfileUserSearch uiProfileUserSearchRelation = null;
    private List<Identity> identityList;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIPageIterator getUIPageIteratorContact() {
        return this.uiPageIteratorContact;
    }

    public UIMyConnections() throws Exception {
        this.addChild((UIComponent)this.uiPageIteratorContact);
        this.uiProfileUserSearchRelation = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.addChild((UIComponent)this.uiProfileUserSearchRelation);
    }

    public List<Relationship> getMyRelation() throws Exception {
        List<Relationship> listContacts = this.getMyContacts();
        List<Relationship> contactLists = this.getDisplayRelationList(listContacts, this.uiPageIteratorContact);
        this.uiProfileUserSearchRelation.setAllUserContactName(this.getAllMyRelationUserNames());
        return contactLists;
    }

    public Identity getCurrentIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getOrCreateIdentity("organization", this.getCurrentVieweredUserName());
    }

    public Identity getCurrentViewerIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        Identity identity = im.getOrCreateIdentity("organization", this.getCurrentVieweredUserName());
        if (identity == null) {
            identity = im.getOrCreateIdentity("organization", this.getCurrentUserName());
        }
        return identity;
    }

    public boolean isEditable() {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        return currentUserName.equals(currentViewer);
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private List<Relationship> getDisplayRelationList(List<Relationship> listContacts, UIPageIterator uiPageIterator) throws Exception {
        int curPage = uiPageIterator.getCurrentPage();
        LazyPageList pageListContact = new LazyPageList((ListAccess)new RelationshipListAccess(listContacts), 5);
        uiPageIterator.setPageList((PageList)pageListContact);
        int availablePageCount = uiPageIterator.getAvailablePage();
        if (availablePageCount >= curPage) {
            uiPageIterator.setCurrentPage(curPage);
        } else if (availablePageCount < curPage) {
            uiPageIterator.setCurrentPage(curPage - 1);
        }
        return uiPageIterator.getCurrentPageData();
    }

    private List<String> getAllMyRelationUserNames() throws Exception {
        RelationshipManager relm = this.getRelationshipManager();
        Identity currentIdentity = this.getCurrentViewerIdentity();
        ArrayList<Identity> allRelationIdentities = new ArrayList<Identity>();
        List allRelations = relm.getContacts(currentIdentity);
        Identity id = null;
        Identity currIdentity = this.getCurrentIdentity();
        for (Relationship rel : allRelations) {
            id = currIdentity.getId() == rel.getSender().getId() ? rel.getReceiver() : rel.getSender();
            allRelationIdentities.add(id);
        }
        ArrayList<String> allUserContactName = new ArrayList<String>();
        for (Identity identity : allRelationIdentities) {
            allUserContactName.add(identity.getProfile().getFullName());
        }
        return allUserContactName;
    }

    private List<Relationship> getMyContacts() throws Exception {
        RelationshipManager relm = this.getRelationshipManager();
        Identity currentIdentity = this.getCurrentViewerIdentity();
        List<Identity> matchIdentities = this.getIdentityList();
        if (matchIdentities == null) {
            return relm.getContacts(currentIdentity);
        }
        return relm.getContacts(currentIdentity, matchIdentities);
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    private String getCurrentVieweredUserName() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        return portalRequest.getRemoteUser();
    }

    private String getCurrentUserName() {
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        return portalRequest.getRemoteUser();
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.relationshipManager = (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    private Relationship.Type getContactStatus(Identity identity) throws Exception {
        if (identity.getId().equals(this.getCurrentIdentity().getId())) {
            return Relationship.Type.SELF;
        }
        RelationshipManager rm = this.getRelationshipManager();
        Relationship rl = rm.getRelationship(identity, this.getCurrentIdentity());
        return rm.getRelationshipStatus(rl, this.getCurrentIdentity());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIMyConnections> {
        public void execute(Event<UIMyConnections> event) throws Exception {
            UIMyConnections uiMyRelation = (UIMyConnections)((Object)event.getSource());
            UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)uiMyRelation.getChild(UIProfileUserSearch.class);
            List<Identity> identityList = uiProfileUserSearch.getIdentityList();
            uiMyRelation.setIdentityList(identityList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIMyConnections> {
        public void execute(Event<UIMyConnections> event) throws Exception {
            UIMyConnections uiMyRelation = (UIMyConnections)((Object)event.getSource());
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            String currUserId = uiMyRelation.getCurrentUserName();
            IdentityManager im = uiMyRelation.getIdentityManager();
            Identity currIdentity = im.getOrCreateIdentity("organization", currUserId);
            Identity requestedIdentity = im.getIdentity(identityId);
            RelationshipManager rm = uiMyRelation.getRelationshipManager();
            UIApplication uiApplication = event.getRequestContext().getUIApplication();
            Relationship.Type relationStatus = uiMyRelation.getContactStatus(requestedIdentity);
            if (relationStatus != Relationship.Type.CONFIRM) {
                uiApplication.addMessage(new ApplicationMessage(UIMyConnections.RELATION_DELETED_INFO, null, 2));
                return;
            }
            Relationship rel = rm.getRelationship(currIdentity, requestedIdentity);
            if (rel != null) {
                rm.remove(rel);
            }
        }
    }
}

