/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserActivityListAccess
implements ListAccess<Activity> {
    private static final Log LOG = ExoLogger.getLogger(UserActivityListAccess.class);
    private Identity ownerIdentity;
    private UIUserActivitiesDisplay.DisplayMode displayMode;
    private ActivityManager activityManager = (ActivityManager)PortalContainer.getComponent(ActivityManager.class);

    public UserActivityListAccess(Identity ownerIdentity, UIUserActivitiesDisplay.DisplayMode displayMode) {
        this.ownerIdentity = ownerIdentity;
        this.displayMode = displayMode;
    }

    public int getSize() throws Exception {
        int size = this.displayMode == UIUserActivitiesDisplay.DisplayMode.MY_STATUS || this.displayMode == UIUserActivitiesDisplay.DisplayMode.OWNER_STATUS ? this.activityManager.getActivitiesCount(this.ownerIdentity) : (this.displayMode == UIUserActivitiesDisplay.DisplayMode.SPACES ? this.activityManager.getActivitiesOfUserSpaces(this.ownerIdentity).size() : this.activityManager.getActivitiesOfConnections(this.ownerIdentity).size());
        return size;
    }

    public Activity[] load(int index, int length) throws Exception {
        List<Activity> activityList = this.displayMode == UIUserActivitiesDisplay.DisplayMode.MY_STATUS || this.displayMode == UIUserActivitiesDisplay.DisplayMode.OWNER_STATUS ? this.activityManager.getActivities(this.ownerIdentity, (long)index, (long)length) : (this.displayMode == UIUserActivitiesDisplay.DisplayMode.SPACES ? this.getActivitiesOfUserSpaces(index, length) : this.getActivitiesOfConnections(index, length));
        return activityList.toArray(new Activity[activityList.size()]);
    }

    private List<Activity> getActivitiesOfConnections(int index, int length) throws Exception {
        List activityList = this.activityManager.getActivitiesOfConnections(this.ownerIdentity);
        return this.getActivityList(index, length, activityList);
    }

    private List<Activity> getActivitiesOfUserSpaces(int index, int length) {
        List activityList = this.activityManager.getActivitiesOfUserSpaces(this.ownerIdentity);
        return this.getActivityList(index, length, activityList);
    }

    private List<Activity> getActivityList(int index, int length, List<Activity> activityList) {
        if (activityList.size() < 1) {
            return activityList;
        }
        int toIndex = length + index;
        toIndex = activityList.size() >= toIndex ? toIndex : activityList.size() + index;
        return activityList.subList(index, toIndex);
    }
}

