/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.UIAvatarUploadContent;
import org.exoplatform.social.webui.UIAvatarUploader;
import org.exoplatform.social.webui.space.UISpaceNavigationManagement;
import org.exoplatform.social.webui.space.UISpaceNavigationNodeSelector;
import org.exoplatform.social.webui.space.UISpaceSetting;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/space/UISpaceInfo.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}, phase=Event.Phase.PROCESS), @EventConfig(listeners={ChangeAvatarActionListener.class})})
public class UISpaceInfo
extends UIForm {
    private final String SPACE_PRIORITY = "priority";
    private final String PRIORITY_HIGH = "high";
    private final String PRIORITY_IMMEDIATE = "immediate";
    private final String PRIORITY_LOW = "low";
    private SpaceService spaceService = null;
    private final String POPUP_AVATAR_UPLOADER = "UIPopupAvatarUploader";

    public UISpaceInfo() throws Exception {
        this.addUIFormInput((UIFormInput)((UIFormStringInput)new UIFormStringInput("id", "id", null).setRendered(false)));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("name", "name", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^([\\p{L}\\d]+[\\s]?)+$", "UISpaceInfo.msg.name-invalid"}).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput("description", "description", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{0, 255}));
        ArrayList<SelectItemOption> priorityList = new ArrayList<SelectItemOption>(3);
        SelectItemOption pHigh = new SelectItemOption("high", (Object)"1");
        SelectItemOption pImmediate = new SelectItemOption("immediate", (Object)"2");
        SelectItemOption pLow = new SelectItemOption("low", (Object)"3");
        priorityList.add(pHigh);
        priorityList.add(pImmediate);
        priorityList.add(pLow);
        UIFormSelectBox selectPriority = new UIFormSelectBox("priority", "priority", priorityList);
        this.addUIFormInput((UIFormInput)selectPriority);
        this.addUIFormInput((UIFormInput)((UIFormStringInput)new UIFormStringInput("tag", "tag", null).setRendered(false)));
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, null, "UIPopupAvatarUploader");
        uiPopup.setWindowSize(500, 0);
        this.addChild((UIComponent)uiPopup);
    }

    public void setValue(Space space) throws Exception {
        this.invokeGetBindingBean(space);
        this.getUIStringInput("tag").setValue((Object)space.getTag());
    }

    public void saveAvatar(UIAvatarUploadContent uiAvatarUploadContent, Space space) throws Exception {
        SpaceService spaceService = this.getSpaceService();
        space.setAvatarAttachment(uiAvatarUploadContent.getAvatarAttachment());
        spaceService.saveSpace(space, false);
    }

    protected String getImageSource() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String id = (String)this.getUIStringInput("id").getValue();
        Space space = spaceService.getSpaceById(id);
        return space.getImageSource();
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    public OrganizationService getOrganizationService() {
        return (OrganizationService)this.getApplicationComponent(OrganizationService.class);
    }

    public DataStorage getDataSource() {
        return (DataStorage)this.getApplicationComponent(DataStorage.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeAvatarActionListener
    extends EventListener<UISpaceInfo> {
        public void execute(Event<UISpaceInfo> event) throws Exception {
            UISpaceInfo uiSpaceInfo = (UISpaceInfo)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceInfo.getChild(UIPopupWindow.class);
            UIAvatarUploader uiAvatarUploader = (UIAvatarUploader)uiSpaceInfo.createUIComponent(UIAvatarUploader.class, null, null);
            uiPopup.setUIComponent((UIComponent)uiAvatarUploader);
            uiPopup.setShow(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISpaceInfo> {
        public void execute(Event<UISpaceInfo> event) throws Exception {
            boolean nameChanged;
            UISpaceInfo uiSpaceInfo = (UISpaceInfo)((Object)event.getSource());
            SpaceService spaceService = uiSpaceInfo.getSpaceService();
            UIPortal uiPortal = Util.getUIPortal();
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            WebuiRequestContext requestContext = event.getRequestContext();
            UIApplication uiApp = requestContext.getUIApplication();
            String id = (String)uiSpaceInfo.getUIStringInput("id").getValue();
            String name = (String)uiSpaceInfo.getUIStringInput("name").getValue();
            Space space = spaceService.getSpaceById(id);
            String spaceUrl = space.getUrl();
            if (space == null) {
                portalRequestContext.getResponse().sendRedirect(portalRequestContext.getPortalURI() + "spaces");
                return;
            }
            PageNode selectedNode = uiPortal.getSelectedNode();
            PageNode homeNode = null;
            boolean bl = nameChanged = !space.getName().equals(name);
            if (nameChanged) {
                String cleanedString = SpaceUtils.cleanString((String)name);
                if (spaceService.getSpaceByUrl(cleanedString) != null) {
                    uiApp.addMessage(new ApplicationMessage("UISpaceInfo.msg.current-name-exist", null, 2));
                    return;
                }
                UserPortalConfig userPortalConfig = Util.getUIPortalApplication().getUserPortalConfig();
                List pageNavigations = userPortalConfig.getNavigations();
                DataStorage dataStorage = (DataStorage)uiSpaceInfo.getApplicationComponent(DataStorage.class);
                space.setUrl(cleanedString);
                PageNavigation spaceNavigation = dataStorage.getPageNavigation("group", space.getGroupId());
                for (PageNavigation pageNavigation : pageNavigations) {
                    if (!pageNavigation.getOwner().equals(spaceNavigation.getOwner())) continue;
                    spaceNavigation = pageNavigation;
                    break;
                }
                if ((homeNode = SpaceUtils.getHomeNode((PageNavigation)spaceNavigation, (String)spaceUrl)) == null) {
                    throw new Exception("homeNode is null!");
                }
                SpaceUtils.changeSpaceUrlPreference((PageNode)homeNode, (Space)space, (String)name);
                homeNode.setUri(cleanedString);
                homeNode.setName(cleanedString);
                homeNode.setLabel(name);
                List childNodes = homeNode.getNodes();
                for (int i = 0; i < childNodes.size(); ++i) {
                    PageNode childNode = (PageNode)childNodes.get(i);
                    SpaceUtils.changeSpaceUrlPreference((PageNode)childNode, (Space)space, (String)name);
                    String oldUri = childNode.getUri();
                    String newUri = oldUri.replace(oldUri.substring(0, oldUri.lastIndexOf("/")), cleanedString);
                    childNode.setUri(newUri);
                    childNode.setName(newUri.substring(newUri.lastIndexOf("/") + 1, newUri.length()));
                    if (!selectedNode.getName().equals(childNode.getName())) continue;
                    selectedNode = childNode;
                }
                dataStorage.save(spaceNavigation);
                uiPortal.setSelectedNode(selectedNode);
                SpaceUtils.setNavigation((PageNavigation)spaceNavigation);
            }
            uiSpaceInfo.invokeSetBindingBean(space);
            spaceService.saveSpace(space, false);
            if (nameChanged) {
                UISpaceSetting uiSpaceSetting = (UISpaceSetting)uiSpaceInfo.getAncestorOfType(UISpaceSetting.class);
                UITabPane uiTabPane = (UITabPane)uiSpaceSetting.getChild(UITabPane.class);
                UISpaceNavigationManagement uiSpaceNavigationManagement = (UISpaceNavigationManagement)uiTabPane.getChild(UISpaceNavigationManagement.class);
                UISpaceNavigationNodeSelector uiSpaceNavigationNodeSelector = (UISpaceNavigationNodeSelector)uiSpaceNavigationManagement.getChild(UISpaceNavigationNodeSelector.class);
                PageNavigation groupNav = SpaceUtils.getGroupNavigation((String)space.getGroupId());
                uiSpaceNavigationNodeSelector.setEdittedNavigation(groupNav);
                uiSpaceNavigationNodeSelector.setEdittedTreeNodeData(null);
                uiSpaceNavigationNodeSelector.initTreeData();
                portalRequestContext.getResponse().sendRedirect(portalRequestContext.getPortalURI() + selectedNode.getUri());
                return;
            }
            uiApp.addMessage(new ApplicationMessage("UISpaceInfo.msg.update-success", null, 2));
        }
    }
}

