/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity.plugin;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.ResourceBundleUtil;
import org.exoplatform.social.core.application.RelationshipPublisher;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/activity/plugin/UIRelationshipActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment"), @EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={RefuseActionListener.class}), @EventConfig(listeners={RevokeActionListener.class})})
public class UIRelationshipActivity
extends BaseUIActivity {
    private static final Log LOG = ExoLogger.getLogger(UIRelationshipActivity.class);
    private RelationshipPublisher.TitleId titleId;
    private String senderName;
    private String receiverName;

    public void setTitleId(RelationshipPublisher.TitleId titleId) {
        this.titleId = titleId;
    }

    public RelationshipPublisher.TitleId getTitleId() {
        return this.titleId;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    public String getSenderProfileLink() {
        return this.getProfileLink(this.senderName);
    }

    public String getReceiverProfileLink() {
        return this.getProfileLink(this.receiverName);
    }

    public boolean isActivityStreamOwner() {
        UIActivitiesContainer uiActivititesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        return remoteUser.equals(uiActivititesContainer.getOwnerName());
    }

    public boolean canShowAcceptRefuseAction() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser().equals(this.getReceiverName());
    }

    public String getActivityTitle(WebuiBindingContext ctx) throws Exception {
        UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getAncestorOfType(UIUserActivitiesDisplay.class);
        UIUserActivitiesDisplay.DisplayMode displayMode = uiUserActivitiesDisplay.getSelectedDisplayMode();
        if (this.titleId == RelationshipPublisher.TitleId.CONNECTION_CONFIRMED) {
            if (this.isActivityStreamOwner() && displayMode == UIUserActivitiesDisplay.DisplayMode.MY_STATUS) {
                return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.You_Are_Now_Connected_With_UserName"), (String[])new String[]{this.getReceiverProfileLink()});
            }
            return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.UserName_Are_Now_Connected_With_UserName"), (String[])new String[]{this.getReceiverProfileLink(), this.getSenderProfileLink()});
        }
        if (this.titleId == RelationshipPublisher.TitleId.CONNECTION_REQUESTED) {
            if (this.isActivityStreamOwner() && displayMode == UIUserActivitiesDisplay.DisplayMode.MY_STATUS) {
                return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.UserName_Invited_You_To_Connect"), (String[])new String[]{this.getSenderProfileLink()});
            }
            return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.UserName_Invited_UserName_To_Connect"), (String[])new String[]{this.getSenderProfileLink(), this.getReceiverProfileLink()});
        }
        return "";
    }

    private String getProfileLink(String username) {
        LinkProvider linkProvider = (LinkProvider)this.getApplicationComponent(LinkProvider.class);
        return linkProvider.getProfileLink(username);
    }

    private IdentityManager getIdentityManager() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
    }

    private RelationshipManager getRelationshipManager() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (RelationshipManager)portalContainer.getComponentInstanceOfType(RelationshipManager.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RevokeActionListener
    extends EventListener<UIRelationshipActivity> {
        public void execute(Event<UIRelationshipActivity> event) throws Exception {
            LOG.info((Object)"Revoke");
            System.out.println("Revoke");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefuseActionListener
    extends EventListener<UIRelationshipActivity> {
        public void execute(Event<UIRelationshipActivity> event) throws Exception {
            Event deleteActivityEvent;
            UIRelationshipActivity uiRelationshipActivity = (UIRelationshipActivity)((Object)event.getSource());
            IdentityManager identityManager = (IdentityManager)uiRelationshipActivity.getApplicationComponent(IdentityManager.class);
            Identity senderIdentity = identityManager.getOrCreateIdentity("organization", uiRelationshipActivity.getSenderName(), false);
            Identity receiverIdentity = identityManager.getOrCreateIdentity("organization", uiRelationshipActivity.getReceiverName(), false);
            RelationshipManager relationshipManager = (RelationshipManager)uiRelationshipActivity.getApplicationComponent(RelationshipManager.class);
            if (receiverIdentity == null || senderIdentity == null) {
                WebuiRequestContext webuiReq = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                webuiReq.getUIApplication().addMessage(new ApplicationMessage("UIRelationshipActivity.msg.error.Can_not_Refuse_Deleted_User", null, 1));
                return;
            }
            Relationship relationship = relationshipManager.getRelationship(receiverIdentity, senderIdentity);
            Relationship.Type status = relationshipManager.getRelationshipStatus(relationship, receiverIdentity);
            if (status == Relationship.Type.REQUIRE_VALIDATION) {
                relationshipManager.deny(relationship);
            }
            if ((deleteActivityEvent = uiRelationshipActivity.createEvent("DeleteActivity", Event.Phase.PROCESS, event.getRequestContext())) != null) {
                deleteActivityEvent.broadcast();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcceptActionListener
    extends EventListener<UIRelationshipActivity> {
        public void execute(Event<UIRelationshipActivity> event) throws Exception {
            Event deleteActivityEvent;
            UIRelationshipActivity uiRelationshipActivity = (UIRelationshipActivity)((Object)event.getSource());
            IdentityManager identityManager = (IdentityManager)uiRelationshipActivity.getApplicationComponent(IdentityManager.class);
            Identity senderIdentity = identityManager.getOrCreateIdentity("organization", uiRelationshipActivity.getSenderName(), false);
            Identity receiverIdentity = identityManager.getOrCreateIdentity("organization", uiRelationshipActivity.getReceiverName(), false);
            RelationshipManager relationshipManager = (RelationshipManager)uiRelationshipActivity.getApplicationComponent(RelationshipManager.class);
            if (receiverIdentity == null || senderIdentity == null) {
                WebuiRequestContext webuiReq = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                webuiReq.getUIApplication().addMessage(new ApplicationMessage("UIRelationshipActivity.msg.error.Can_not_Accept_Deleted_User", null, 1));
                return;
            }
            Relationship relationship = relationshipManager.getRelationship(receiverIdentity, senderIdentity);
            Relationship.Type status = relationshipManager.getRelationshipStatus(relationship, receiverIdentity);
            if (status == Relationship.Type.REQUIRE_VALIDATION) {
                relationshipManager.confirm(relationship);
            }
            if ((deleteActivityEvent = uiRelationshipActivity.createEvent("DeleteActivity", Event.Phase.PROCESS, event.getRequestContext())) != null) {
                deleteActivityEvent.broadcast();
            }
        }
    }
}

