/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.RelationshipListAccess;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/connections/UIInvitations.gtmpl", events={@EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={DenyActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIInvitations
extends UIContainer {
    private static final String iteratorIDInvitation = "UIPageIteratorInvitation";
    private static final String INVITATION_REVOKED_INFO = "UIInvitations.label.RevokedInfo";
    private static final String INCOMING_STATUS = "incoming";
    private UIPageIterator uiPageIteratorInvitation = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIPageIteratorInvitation");
    UIProfileUserSearch uiProfileUserSearchRelation = null;
    private List<Identity> identityList;
    private static final int FIRST_PAGE = 1;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIPageIterator getUIPageIteratorInvitation() {
        return this.uiPageIteratorInvitation;
    }

    public UIInvitations() throws Exception {
        this.addChild((UIComponent)this.uiPageIteratorInvitation);
        this.uiProfileUserSearchRelation = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.uiProfileUserSearchRelation.setTypeOfRelation(INCOMING_STATUS);
        this.addChild((UIComponent)this.uiProfileUserSearchRelation);
    }

    public List<Relationship> getInvitation() throws Exception {
        List<Relationship> invitationList = this.getInvitedRelations();
        if (invitationList == null) {
            return null;
        }
        List<Relationship> contactLists = this.getDisplayRelationList(invitationList, this.uiPageIteratorInvitation);
        return contactLists;
    }

    public boolean isEditable() {
        return Utils.isOwner();
    }

    private List<Relationship> getDisplayRelationList(List<Relationship> listContacts, UIPageIterator uiPageIterator) throws Exception {
        int curPage = uiPageIterator.getCurrentPage();
        LazyPageList pageListContact = new LazyPageList((ListAccess)new RelationshipListAccess(listContacts), 5);
        uiPageIterator.setPageList((PageList)pageListContact);
        if (this.uiProfileUserSearchRelation.isNewSearch()) {
            uiPageIterator.setCurrentPage(1);
        } else {
            uiPageIterator.setCurrentPage(curPage);
        }
        this.uiProfileUserSearchRelation.setNewSearch(false);
        return uiPageIterator.getCurrentPageData();
    }

    private List<Relationship> getInvitedRelations() throws Exception {
        return Utils.getRelationshipManager().getIncoming(Utils.getOwnerIdentity(), this.getIdentityList());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiMyRelation = (UIInvitations)((Object)event.getSource());
            UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)uiMyRelation.getChild(UIProfileUserSearch.class);
            List<Identity> identityList = uiProfileUserSearch.getIdentityList();
            uiMyRelation.setIdentityList(identityList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DenyActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            Identity requestedIdentity = Utils.getIdentityManager().getIdentity(identityId);
            Relationship relationship = Utils.getRelationshipManager().get(Utils.getViewerIdentity(), requestedIdentity);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIInvitations.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().deny(relationship);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcceptActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            Identity requestedIdentity = Utils.getIdentityManager().getIdentity(identityId);
            Relationship relationship = Utils.getRelationshipManager().get(Utils.getOwnerIdentity(), requestedIdentity);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIInvitations.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().confirm(relationship);
        }
    }
}

