/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/space/UIManagePendingSpaces.gtmpl", events={@EventConfig(listeners={RevokePendingActionListener.class})})
public class UIManagePendingSpaces
extends UIContainer {
    private static final String MSG_ERROR_REVOKE_PENDING = "UIManagePendingSpaces.msg.error_revoke_pending";
    private static final String SPACE_DELETED_INFO = "UIManagePendingSpaces.msg.DeletedInfo";
    private static final String PENDING_STATUS = "pending";
    private static final String SEARCH_ALL = "All";
    private static final int FIRST_PAGE = 1;
    SpaceService spaceService = null;
    String userId = null;
    private UIPageIterator iterator;
    private final String ITERATOR_ID = "UIIteratorPendingSpaces";
    private final Integer SPACES_PER_PAGE = 4;
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");

    public UIManagePendingSpaces() throws Exception {
        this.uiSpaceSearch.setTypeOfRelation(PENDING_STATUS);
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorPendingSpaces");
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public List<Space> getAllPendingSpaces() throws SpaceException {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        List userSpaces = spaceService.getPendingSpaces(userId);
        return SpaceUtils.getOrderedSpaces((List)userSpaces);
    }

    public List<Space> getPendingSpaces() throws Exception {
        this.uiSpaceSearch.setSpaceNameForAutoSuggest(this.getPendingSpaceNames());
        return this.getDisplayPendingSpaces(this.iterator);
    }

    public String getImageSource(Space space) throws Exception {
        return space.getAvatarUrl();
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    private List<String> getPendingSpaceNames() throws SpaceException {
        List<Space> pendingSpaces = this.getAllPendingSpaces();
        ArrayList<String> pendingSpaceNames = new ArrayList<String>();
        for (Space space : pendingSpaces) {
            pendingSpaceNames.add(space.getDisplayName());
        }
        return pendingSpaceNames;
    }

    private List<Space> getDisplayPendingSpaces(UIPageIterator iterator) throws Exception {
        int currentPage = iterator.getCurrentPage();
        String selectedChar = this.uiSpaceSearch.getSelectedChar();
        String spaceNameSearch = this.uiSpaceSearch.getSpaceNameSearch();
        LazyPageList pageList = null;
        if (selectedChar == null && spaceNameSearch == null || selectedChar != null && selectedChar.equals(SEARCH_ALL)) {
            pageList = new LazyPageList(this.spaceService.getPendingSpacesWithListAccess(this.userId), this.SPACES_PER_PAGE.intValue());
        } else {
            SpaceFilter spaceFilter = null;
            spaceFilter = selectedChar != null ? new SpaceFilter(selectedChar.charAt(0)) : new SpaceFilter(spaceNameSearch);
            pageList = new LazyPageList(this.spaceService.getPendingSpacesByFilter(this.userId, spaceFilter), this.SPACES_PER_PAGE.intValue());
        }
        iterator.setPageList((PageList)pageList);
        int availablePage = iterator.getAvailablePage();
        if (this.uiSpaceSearch.isNewSearch()) {
            iterator.setCurrentPage(1);
        } else if (currentPage > availablePage) {
            iterator.setCurrentPage(availablePage);
        } else {
            iterator.setCurrentPage(currentPage);
        }
        this.uiSpaceSearch.setNewSearch(false);
        return iterator.getCurrentPageData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RevokePendingActionListener
    extends EventListener<UIManagePendingSpaces> {
        public void execute(Event<UIManagePendingSpaces> event) throws Exception {
            UIManagePendingSpaces uiPendingSpaces = (UIManagePendingSpaces)((Object)event.getSource());
            SpaceService spaceService = uiPendingSpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiPendingSpaces.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManagePendingSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            spaceService.removePendingUser(space, userId);
        }
    }
}

