/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.application.registry.Application;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceApplicationList;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/space/UISpaceApplication.gtmpl", events={@EventConfig(listeners={AddApplicationActionListener.class}), @EventConfig(listeners={RemoveApplicationActionListener.class})})
public class UISpaceApplication
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(UISpaceApplication.class);
    private Space space;
    private UIPageIterator iterator;
    private final String iteratorID = "UIIteratorSpaceApplication";

    public UISpaceApplication() throws Exception {
        this.addChild(UIPopupContainer.class, null, "UIPopupAddApp");
        this.iterator = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorSpaceApplication");
        this.addChild((UIComponent)this.iterator);
    }

    public List<Application> getApplications() throws Exception {
        return this.iterator.getCurrentPageData();
    }

    public String getApplicationName(String appName) {
        int colonIndex = appName.indexOf(":");
        if (colonIndex > 0) {
            appName = appName.substring(0, colonIndex);
        }
        return appName;
    }

    public void setValue(Space space) throws Exception {
        this.space = space;
        List appIdList = SpaceUtils.getAppIdList((Space)space);
        ArrayList notAvailableAppIdList = new ArrayList(appIdList);
        ArrayList<Application> installedAppList = new ArrayList<Application>();
        Map appStore = SpaceUtils.getAppStore((Space)space);
        for (Map.Entry appCategoryEntrySet : appStore.entrySet()) {
            List appList = (List)appCategoryEntrySet.getValue();
            for (Application app : appList) {
                String appStatus;
                if (this.isExisted(installedAppList, app) || !appIdList.contains(app.getApplicationName()) || !(appStatus = SpaceUtils.getAppStatus((Space)space, (String)app.getApplicationName())).equals("active")) continue;
                installedAppList.add(app);
                notAvailableAppIdList.remove(app.getApplicationName());
            }
        }
        ArrayList<String> availableAppIdList = new ArrayList<String>();
        for (String appId : appIdList) {
            if (availableAppIdList.contains(appId)) continue;
            availableAppIdList.add(appId);
        }
        for (String appId : availableAppIdList) {
            if (!SpaceUtils.getAppStatus((Space)space, (String)appId).equals("active")) continue;
            installedAppList.add(SpaceUtils.getAppFromPortalContainer((String)appId));
        }
        String apps = space.getApp();
        String[] listApp = apps.split(",");
        ArrayList<Application> installedApps = new ArrayList<Application>();
        block4: for (int index = 0; index < listApp.length; ++index) {
            for (int idx = 0; idx < installedAppList.size(); ++idx) {
                String[] appParts;
                String spaceAppName;
                Application application = (Application)installedAppList.get(idx);
                String temporalSpaceName = application.getApplicationName();
                if (!temporalSpaceName.equals(spaceAppName = (appParts = listApp[index].split(":"))[0])) continue;
                String newName = appParts[0] + ":" + appParts[1];
                installedApps.add(this.setAppName(application, newName));
                continue block4;
            }
        }
        ObjectPageList pageList = new ObjectPageList(installedApps, 3);
        this.iterator.setPageList((PageList)pageList);
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public boolean isRemovable(String appId) {
        return SpaceUtils.isRemovableApp((Space)this.space, (String)appId);
    }

    public String getAppName(Application application) throws SpaceException {
        String spaceUrl = SpaceUtils.getSpaceUrl();
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        Space space = spaceService.getSpaceByUrl(spaceUrl);
        if (space == null) {
            return null;
        }
        PageNavigation pageNav = null;
        try {
            pageNav = SpaceUtils.getGroupNavigation((String)space.getGroupId());
        }
        catch (Exception e1) {
            LOG.warn((Object)e1.getMessage(), (Throwable)e1);
        }
        PageNode homeNode = SpaceUtils.getHomeNode((PageNavigation)pageNav, (String)spaceUrl);
        if (homeNode == null) {
            return null;
        }
        List nodes = homeNode.getChildren();
        String applicationName = application.getApplicationName();
        String appName = applicationName.split(":")[1];
        for (PageNode node : nodes) {
            String nodeUri = node.getUri();
            String appNodeName = nodeUri.substring(nodeUri.indexOf("/") + 1);
            if (!appNodeName.equals(appName)) continue;
            return SpaceUtils.getDisplayAppName((String)node.getResolvedLabel());
        }
        return SpaceUtils.getDisplayAppName((String)application.getDisplayName());
    }

    private boolean isExisted(List<Application> appList, Application app) {
        String appName = app.getApplicationName();
        String existedAppName = null;
        for (Application application : appList) {
            existedAppName = application.getApplicationName();
            if (!existedAppName.equals(appName)) continue;
            return true;
        }
        return false;
    }

    private Application setAppName(Application application, String appName) {
        Application app = new Application();
        app.setCategoryName(application.getCategoryName());
        app.setDisplayName(application.getDisplayName());
        app.setDescription(application.getDescription());
        app.setCreatedDate(application.getCreatedDate());
        app.setModifiedDate(application.getModifiedDate());
        app.setAccessPermissions(application.getAccessPermissions());
        app.setApplicationName(appName);
        app.setType(application.getType());
        app.setStorageId(application.getStorageId());
        app.setId(application.getId());
        app.setIconURL(application.getIconURL());
        app.setContentId(application.getContentId());
        return app;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveApplicationActionListener
    extends EventListener<UISpaceApplication> {
        public void execute(Event<UISpaceApplication> event) throws Exception {
            UISpaceApplication uiSpaceApp = (UISpaceApplication)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            String removedAppName = context.getRequestParameter("objectId");
            SpaceService spaceService = (SpaceService)uiSpaceApp.getApplicationComponent(SpaceService.class);
            String appId = null;
            String appName = null;
            String[] removedApps = removedAppName.split(":");
            if (removedApps.length == 2) {
                appId = removedApps[0];
                appName = removedApps[1];
            } else {
                appId = removedAppName;
            }
            spaceService.removeApplication(uiSpaceApp.space.getId(), appId, appName);
            uiSpaceApp.setValue(spaceService.getSpaceById(uiSpaceApp.space.getId()));
            UIPopupContainer uiPopup = (UIPopupContainer)uiSpaceApp.getChild(UIPopupContainer.class);
            if (((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).isShow()) {
                UISpaceApplicationList uiSpaceAppList = (UISpaceApplicationList)uiPopup.activate(UISpaceApplicationList.class, 400);
                uiSpaceAppList.setSpace(uiSpaceApp.space);
                context.addUIComponentToUpdateByAjax((UIComponent)uiPopup);
            }
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddApplicationActionListener
    extends EventListener<UISpaceApplication> {
        public void execute(Event<UISpaceApplication> event) throws Exception {
            UISpaceApplication uiSpaceApp = (UISpaceApplication)((Object)event.getSource());
            UIPopupContainer uiPopup = (UIPopupContainer)uiSpaceApp.getChild(UIPopupContainer.class);
            UISpaceApplicationList uiSpaceAppList = (UISpaceApplicationList)uiPopup.activate(UISpaceApplicationList.class, 400);
            uiSpaceAppList.setSpace(uiSpaceApp.space);
            ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId("AddApplication");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }
}

