/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/connections/UIMyConnections.gtmpl", events={@EventConfig(listeners={RemoveActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIMyConnections
extends UIContainer {
    private static final String iteratorIDContact = "UIPageIteratorContact";
    private static final String RELATION_DELETED_INFO = "UIMyConnections.label.DeletedInfo";
    private static final String CONFIRMED_STATUS = "confirmed";
    UIPageIterator uiPageIteratorContact = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIPageIteratorContact");
    UIProfileUserSearch uiProfileUserSearchRelation = null;
    private List<Identity> identityList;
    private static final int FIRST_PAGE = 1;
    private static final int RELATIONSHIP_PER_PAGE = 5;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIPageIterator getUIPageIteratorContact() {
        return this.uiPageIteratorContact;
    }

    public UIMyConnections() throws Exception {
        this.addChild((UIComponent)this.uiPageIteratorContact);
        this.uiProfileUserSearchRelation = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.uiProfileUserSearchRelation.setTypeOfRelation(CONFIRMED_STATUS);
        this.addChild((UIComponent)this.uiProfileUserSearchRelation);
        this.identityList = new ArrayList<Identity>();
    }

    public List<Identity> getMyRelation() throws Exception {
        int curPage = this.uiPageIteratorContact.getCurrentPage();
        ListAccess connectionListAccess = Utils.getRelationshipManager().getConnections(Utils.getOwnerIdentity());
        if (connectionListAccess != null && connectionListAccess.getSize() == 0) {
            return new ArrayList<Identity>();
        }
        LazyPageList pageListContact = new LazyPageList(connectionListAccess, 5);
        this.uiPageIteratorContact.setPageList((PageList)pageListContact);
        int availablePage = this.uiPageIteratorContact.getAvailablePage();
        if (this.uiProfileUserSearchRelation.isNewSearch()) {
            this.uiPageIteratorContact.setCurrentPage(1);
        } else if (curPage > availablePage) {
            this.uiPageIteratorContact.setCurrentPage(availablePage);
        } else {
            this.uiPageIteratorContact.setCurrentPage(curPage);
        }
        this.uiProfileUserSearchRelation.setNewSearch(false);
        return this.uiPageIteratorContact.getCurrentPageData();
    }

    public boolean isEditable() {
        return Utils.isOwner();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIMyConnections> {
        public void execute(Event<UIMyConnections> event) throws Exception {
            UIMyConnections uiMyRelation = (UIMyConnections)((Object)event.getSource());
            UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)uiMyRelation.getChild(UIProfileUserSearch.class);
            List<Identity> identityList = uiProfileUserSearch.getIdentityList();
            uiMyRelation.setIdentityList(identityList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIMyConnections> {
        public void execute(Event<UIMyConnections> event) throws Exception {
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            Identity requestedIdentity = Utils.getIdentityManager().getIdentity(identityId, true);
            Relationship relationship = Utils.getRelationshipManager().get(Utils.getOwnerIdentity(), requestedIdentity);
            if (relationship == null || relationship.getStatus() != Relationship.Type.CONFIRMED) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIMyConnections.RELATION_DELETED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().delete(relationship);
        }
    }
}

