/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.benches;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.extras.benches.ExoSocialDataInjectionExecutor;

public class ExoSocialDataInjector
extends DataInjector {
    private static Log LOG = ExoLogger.getLogger(ExoSocialDataInjector.class);
    private long numberOfUser;
    private long numberOfRelation;
    private long numberOfActivity;
    private long numberOfSpace;
    private ExoSocialDataInjectionExecutor injector;
    private boolean isInitialized = false;
    private Map<String, Long> userActivities = new HashMap<String, Long>();

    public ExoSocialDataInjector(ExoSocialDataInjectionExecutor injector) {
        this.injector = injector;
    }

    public Log getLog() {
        return null;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initParams(InitParams initParams) {
        if (initParams != null) {
            ValueParam vParam = (ValueParam)initParams.get((Object)"mU");
            this.numberOfUser = this.longValue("mU", vParam.getValue());
            vParam = (ValueParam)initParams.get((Object)"mR");
            this.numberOfRelation = this.longValue("mR", vParam.getValue());
            vParam = (ValueParam)initParams.get((Object)"mA");
            this.numberOfActivity = this.longValue("mA", vParam.getValue());
        }
    }

    public void inject() throws Exception {
        LOG.info((Object)"starting...");
        boolean nothingWasDone = true;
        if (this.numberOfUser > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.numberOfUser + " people."));
            this.injector.generatePeople(this.numberOfUser);
        }
        if (this.numberOfRelation > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.numberOfRelation + " connections."));
            this.injector.generateRelations(this.numberOfRelation);
        }
        if (this.numberOfActivity > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.numberOfActivity + " activities."));
            this.injector.generateActivities(this.numberOfActivity);
        }
        if (!this.userActivities.isEmpty()) {
            Set<Map.Entry<String, Long>> entries = this.userActivities.entrySet();
            for (Map.Entry<String, Long> entry : entries) {
                String username = entry.getKey();
                Long count = entry.getValue();
                LOG.info((Object)("\t> about to inject " + count + " activities for " + username + "."));
                this.injector.generateActivities(username, count);
            }
        }
        if (nothingWasDone) {
            LOG.info((Object)"nothing to inject.");
        }
        this.isInitialized = true;
    }

    public void reject() throws Exception {
        throw new UnsupportedOperationException();
    }

    private long longValue(String property, String value) {
        try {
            if (value != null) {
                return Long.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Long number expected for property " + property));
        }
        return 0L;
    }
}

