/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.benches;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.extras.benches.util.LoremIpsum4J;
import org.exoplatform.social.extras.benches.util.NameGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoSocialDataInjectionExecutor {
    private static Log LOG = ExoLogger.getLogger(ExoSocialDataInjectionExecutor.class);
    private LoremIpsum4J lorem = new LoremIpsum4J();
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;
    private OrganizationService orgnizationservice;
    private UserHandler userHandler;
    private AtomicInteger userCount;
    private AtomicInteger relationshipCount;
    private AtomicInteger activityUserCount;
    private AtomicInteger spaceCount;
    private NameGenerator nameGenerator;

    public ExoSocialDataInjectionExecutor(ActivityManager activityManager, IdentityManager identityManager, RelationshipManager relationshipManager, SpaceService spaceService, OrganizationService organizationService) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.relationshipManager = relationshipManager;
        this.spaceService = spaceService;
        this.orgnizationservice = organizationService;
        this.userHandler = this.orgnizationservice.getUserHandler();
        this.userCount = new AtomicInteger(0);
        this.relationshipCount = new AtomicInteger(0);
        this.activityUserCount = new AtomicInteger(0);
        this.spaceCount = new AtomicInteger(0);
        this.nameGenerator = new NameGenerator();
    }

    public Collection<Identity> generatePeople(long count) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        int i = 0;
        while ((long)i < count) {
            Identity identity = this.generateUser();
            if (identity != null) {
                identities.add(identity);
            }
            ++i;
        }
        return identities;
    }

    public Collection<Relationship> generateRelations(long count) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        int i = 0;
        while ((long)i < count) {
            Relationship relationship = this.generateRelationship();
            if (relationship != null) {
                relationships.add(relationship);
            }
            ++i;
        }
        return relationships;
    }

    public Collection<ExoSocialActivity> generateActivities(long count) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        int i = 0;
        while ((long)i < count) {
            ExoSocialActivity activity = this.generateActivity();
            if (activity != null) {
                activities.add(activity);
            }
            ++i;
        }
        return activities;
    }

    public Collection<ExoSocialActivity> generateActivities(Identity identity, long count) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        int i = 0;
        while ((long)i < count) {
            ExoSocialActivity activity = this.generateActivity(identity);
            if (activity != null) {
                activities.add(activity);
            }
            ++i;
        }
        return activities;
    }

    public Collection<ExoSocialActivity> generateActivities(String user, long count) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", user);
            int i = 0;
            while ((long)i < count) {
                ExoSocialActivity activity = this.generateActivity(identity);
                if (activity != null) {
                    activities.add(activity);
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to generate activities for " + user), (Throwable)e);
        }
        return activities;
    }

    private ExoSocialActivity generateActivity(Identity id1) {
        ExoSocialActivity activity = null;
        if (id1 != null) {
            try {
                int idx = this.activityUserCount.getAndIncrement();
                activity = this.generateRandomActivity();
                activity.setExternalId("benches:" + idx);
                this.activityManager.saveActivity(id1, activity);
                LOG.info((Object)("created activity " + activity.getExternalId()));
            }
            catch (Exception e) {
                LOG.error((Object)("failed to save activity for " + id1 + ": " + e.getMessage()));
            }
        }
        return activity;
    }

    private ExoSocialActivity generateActivity() {
        Identity id1 = this.selectRandomUser(null);
        return this.generateActivity(id1);
    }

    private ExoSocialActivity generateRandomUserActivity() {
        Identity id1 = this.selectRandomUser(null);
        return this.generateActivity(id1);
    }

    private ExoSocialActivity generateRandomActivity() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        LoremIpsum4J lorem = new LoremIpsum4J();
        activity.setBody(lorem.getWords(10));
        activity.setTitle(lorem.getParagraphs());
        return activity;
    }

    private Relationship generateRelationship() {
        Identity[] pple = this.selectUnrelatedUsers();
        Relationship relationship = null;
        if (pple != null) {
            try {
                int idx = this.relationshipCount.getAndIncrement();
                relationship = this.relationshipManager.inviteToConnect(pple[0], pple[1]);
                this.relationshipManager.confirm(pple[0], pple[1]);
            }
            catch (Exception e) {
                LOG.error((Object)("failed to create connection between " + pple[0] + " and " + pple[1] + ": " + e.getMessage()));
            }
            LOG.info((Object)("created connection " + relationship + "."));
        }
        return relationship;
    }

    private Identity[] selectUnrelatedUsers() {
        Identity id1 = this.selectRandomUser(null);
        Identity id2 = this.selectRandomUser(id1);
        if (id1 != null && id2 != null) {
            return new Identity[]{id1, id2};
        }
        return null;
    }

    private Identity selectRandomUser(Identity except) {
        Identity identity = null;
        int limit = 10;
        String username = null;
        while (identity == null) {
            try {
                username = this.username(this.getRandomUserIndex());
                identity = this.identityManager.getIdentity("organization", username, false);
                if (except != null && except.getId().equals(identity.getId())) {
                    identity = null;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("failed to get identity for " + username + ": " + e.getMessage()));
            }
            if (--limit != 0) continue;
            LOG.warn((Object)"failed to select a random user after 10 attempts. Make sure enough identities are populated.");
            break;
        }
        return identity;
    }

    private int getRandomUserIndex() {
        Random rnd = new Random();
        return rnd.nextInt(this.userCount.get());
    }

    private Identity generateUser() {
        User user = this.generateOrgUser();
        Identity identity = this.generateSocialIdentity(user);
        return identity;
    }

    private Identity generateSocialIdentity(User user) {
        Identity identity = null;
        if (user != null) {
            String username = null;
            try {
                username = user.getUserName();
                identity = this.identityManager.getOrCreateIdentity("organization", username);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to generate social identity for " + username + ": " + e.getMessage()));
            }
        }
        return identity;
    }

    private User generateOrgUser() {
        User user = null;
        boolean avail = false;
        while (!avail) {
            int idx = this.userCount.getAndIncrement();
            String username = this.username(idx);
            LOG.info((Object)("creating org user : " + username));
            try {
                user = this.userHandler.findUserByName(username);
            }
            catch (Exception e) {
                LOG.warn((Object)("failed to check existence of  " + username + ": " + e.getMessage()));
            }
            if (user != null) {
                LOG.info((Object)(username + " already exists, skipping"));
                continue;
            }
            try {
                avail = true;
                user = this.userHandler.createUserInstance(username);
                this.initRandomUser(user, username);
                this.userHandler.createUser(user, true);
            }
            catch (Exception e) {
                LOG.warn((Object)("failed to create user " + username + ": " + e.getMessage()));
                return null;
            }
        }
        return user;
    }

    public Map<Identity, Set<Space>> generateSpacesForRandomIdentity(Collection<Identity> identities, int count) {
        ExoContainer pc = ExoContainerContext.getCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)pc);
        HashMap<Identity, Set<Space>> identitySpacesMap = new HashMap<Identity, Set<Space>>();
        HashSet<Space> spaces = new HashSet<Space>(count);
        Identity identity = null;
        for (int i = 0; i < count; ++i) {
            Set oldSpaces;
            identity = this.selectRandomUser(null);
            Space space = this.generateSpace(identity.getRemoteId());
            LOG.info((Object)("creating space : " + space.getDisplayName() + " for: " + identity.getRemoteId()));
            if (space != null) {
                spaces.add(space);
            }
            if ((oldSpaces = (Set)identitySpacesMap.get(identity)) != null) {
                oldSpaces.addAll(spaces);
                identitySpacesMap.put(identity, oldSpaces);
            } else {
                identitySpacesMap.put(identity, spaces);
            }
            spaces = new HashSet(count);
        }
        RequestLifeCycle.end();
        return identitySpacesMap;
    }

    public Map<Space, Identity> generateSpaces(Collection<Identity> identities, long count) {
        ExoContainer pc = ExoContainerContext.getCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)pc);
        HashMap<Space, Identity> spaceIdentityMap = new HashMap<Space, Identity>();
        for (Identity identity : identities) {
            int i = 0;
            while ((long)i < count) {
                Space space = this.generateSpace(identity.getRemoteId());
                LOG.info((Object)("creating space : " + space.getDisplayName() + " for: " + identity.getRemoteId()));
                if (space != null) {
                    spaceIdentityMap.put(space, identity);
                }
                ++i;
            }
        }
        RequestLifeCycle.end();
        return spaceIdentityMap;
    }

    public void generateActivitySpace(Space space, Identity identity, long count) {
        int i = 0;
        while ((long)i < count) {
            String activityMessage = this.lorem.getWords(10);
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
            this.activityManager.recordActivity(spaceIdentity, "exosocial:spaces", activityMessage);
            LOG.info((Object)("creating activity of  : " + identity.getRemoteId() + " with space: " + space.getDisplayName()));
            ++i;
        }
    }

    public Space generateSpace(String username) {
        Space space = null;
        boolean avail = false;
        while (!avail) {
            int idx = this.spaceCount.getAndIncrement();
            String spacename = this.spacename(idx);
            LOG.info((Object)("creating space : " + spacename));
            try {
                space = this.spaceService.getSpaceByDisplayName(spacename);
            }
            catch (Exception e) {
                LOG.warn((Object)("failed to check existence of  " + spacename + ": " + e.getMessage()));
            }
            if (space != null) {
                LOG.info((Object)(spacename + " already exists, skipping"));
                continue;
            }
            try {
                avail = true;
                space = new Space();
                space.setGroupId("organization");
                space.setDisplayName(spacename);
                space.setRegistration("open");
                LoremIpsum4J lorem = new LoremIpsum4J();
                space.setDescription(lorem.getWords(10));
                space.setType("classic");
                space.setVisibility("public");
                space.setPriority("2");
                space = this.spaceService.createSpace(space, username, null);
            }
            catch (Exception e) {
                LOG.warn((Object)("failed to create space " + spacename + ": " + e.getMessage()));
                return null;
            }
        }
        return space;
    }

    void initRandomUser(User user, String username) {
        user.setEmail(username + "@exoplatform.int");
        user.setFirstName(this.nameGenerator.compose(3));
        user.setLastName(this.nameGenerator.compose(4));
        user.setPassword("exo");
    }

    private String username(int idx) {
        return "bench.user" + idx;
    }

    private String spacename(int idx) {
        return "bench.space" + idx;
    }

    public AtomicInteger getUserCount() {
        return this.userCount;
    }

    public AtomicInteger getRelationshipCount() {
        return this.relationshipCount;
    }

    public AtomicInteger getActivityCount() {
        return this.activityUserCount;
    }

    public AtomicInteger getSpaceCount() {
        return this.spaceCount;
    }
}

