/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.benches.util;

import org.exoplatform.social.extras.benches.util.Range;

public class RangeCalculator {
    public static Range[] calculateRange(long totalNumber, long[] ranks) {
        if (totalNumber < 0L) {
            throw new IllegalArgumentException("Rank's value is invalid.");
        }
        Range[] result = null;
        if (ranks == null || ranks.length == 0) {
            result = new Range[1];
            long low = 0L;
            long high = totalNumber - 1L;
            result[0] = new Range(low, high, totalNumber);
            return result;
        }
        if (totalNumber < (long)ranks.length) {
            throw new IllegalArgumentException("Rank's value is invalid.");
        }
        result = new Range[ranks.length];
        long rangeValue = totalNumber / (long)ranks.length;
        long loop = ranks.length;
        long low = 0L;
        long high = 0L;
        int i = 0;
        while ((long)i < loop) {
            low = (long)i * rangeValue;
            high = (long)(i + 1) * rangeValue;
            result[i] = new Range(low, high, ranks[i]);
            ++i;
        }
        if (result[ranks.length - 1] != null) {
            high = result[ranks.length - 1].getHigh();
            result[ranks.length - 1].setHigh(high += totalNumber % loop);
        }
        return result;
    }
}

