/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.plugin.doc.UIDocActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class UIDocActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(UIDocActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, Activity activity) {
        UIDocActivity docActivity = (UIDocActivity)uiActivity;
        String repository = null;
        String workspace = null;
        if (activity.getTemplateParams() != null) {
            Map activityParams = activity.getTemplateParams();
            docActivity.docLink = (String)activityParams.get("DOCLINK");
            docActivity.docName = (String)activityParams.get("DOCNAME");
            docActivity.message = (String)activityParams.get("MESSAGE");
            docActivity.docPath = (String)activityParams.get("DOCPATH");
            repository = (String)activityParams.get("REPOSITORY");
            workspace = (String)activityParams.get("WORKSPACE");
        } else {
            try {
                JSONObject jsonObject = new JSONObject(activity.getTitle());
                docActivity.docLink = jsonObject.getString("DOCLINK");
                docActivity.docName = jsonObject.getString("DOCNAME");
                docActivity.message = jsonObject.getString("MESSAGE");
                docActivity.docPath = jsonObject.getString("DOCPATH");
                repository = jsonObject.getString("REPOSITORY");
                workspace = jsonObject.getString("WORKSPACE");
                this.saveToNewDataFormat(activity, docActivity, repository, workspace);
            }
            catch (JSONException je) {
                LOG.error((Object)"Error with activity's title data");
            }
        }
        NodeLocation nodeLocation = new NodeLocation(repository, workspace, docActivity.docPath);
        Node docNode = NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
        docActivity.setDocNode(docNode);
    }

    private void saveToNewDataFormat(Activity activity, UIDocActivity docActivity, String repository, String workspace) {
        String docActivityTitle = "Shared a document <a href=\"${DOCLINK}\">${DOCNAME}</a>";
        activity.setTitle("Shared a document <a href=\"${DOCLINK}\">${DOCNAME}</a>");
        HashMap<String, String> activityParams = new HashMap<String, String>();
        activityParams.put("DOCNAME", docActivity.docName);
        activityParams.put("DOCLINK", docActivity.docLink);
        activityParams.put("DOCPATH", docActivity.docPath);
        activityParams.put("REPOSITORY", repository);
        activityParams.put("WORKSPACE", workspace);
        activityParams.put("MESSAGE", docActivity.message);
        activity.setTemplateParams(activityParams);
        ActivityManager activityManager = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
        activityManager.saveActivity(activity);
    }
}

