/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.feedmash;

import com.sun.syndication.feed.synd.SyndCategoryImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import java.util.Date;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.application.Application;
import org.exoplatform.social.core.activitystream.ActivityManager;
import org.exoplatform.social.core.activitystream.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.feedmash.AbstractFeedRepubJob;
import org.quartz.JobDataMap;

public class JiraFeedConsumer
extends AbstractFeedRepubJob {
    private static final Log LOG = ExoLogger.getLogger(JiraFeedConsumer.class);
    private String jiraLogo = "http://www.meta-inf.hu/images/atlassian/logo-jira.gif";
    private String baseUrl;
    private String project;

    public void beforeJobExecute(JobDataMap dataMap) {
        this.baseUrl = this.getStringParam(dataMap, "baseURL", null);
        this.project = this.getStringParam(dataMap, "project", null);
        if (this.feedUrl == null) {
            this.feedUrl = this.baseUrl + "/plugins/servlet/streams?key=" + this.project;
        }
        this.categoryMatch = dataMap.getString("categoryMatch");
    }

    protected void handle(SyndEntryImpl entry) {
        try {
            String id = this.targetUser;
            LOG.debug((Object)("republishing jira activity on : " + id + "'s stream, entry uri: " + entry.getLink()));
            Identity targetStream = this.getIdentity(this.targetUser);
            if (targetStream == null) {
                return;
            }
            Identity jira = this.getJiraIdentity();
            ActivityManager activityManager = this.getExoComponent(ActivityManager.class);
            Activity activity = new Activity();
            activity.setTitle("");
            activity.setBody(entry.getTitle());
            activity.setAppId("feedmash:" + this.getClass());
            activity.setUserId(jira.getId());
            activityManager.saveActivity(targetStream, activity);
            this.saveState("lastChecked", new Date());
        }
        catch (Exception e) {
            LOG.error((Object)("failed to republish jira activity: " + e.getMessage()), (Throwable)e);
        }
    }

    private Identity getJiraIdentity() throws Exception {
        Application jiraApp = this.jiraApp();
        return this.getAppIdentity(jiraApp);
    }

    private Application jiraApp() {
        Application application = new Application();
        application.setId("jira-" + this.project);
        application.setName("JIRA (" + this.project + ")");
        String url = this.baseUrl + "/browse/" + this.project;
        application.setUrl(url);
        application.setIcon(this.jiraLogo);
        return application;
    }

    protected boolean accept(SyndEntryImpl entry) {
        if (this.alreadyChecked(entry.getUpdatedDate())) {
            return false;
        }
        List cats = entry.getCategories();
        for (SyndCategoryImpl category : cats) {
            if (!category.getName().matches(this.categoryMatch)) continue;
            return true;
        }
        return false;
    }
}

