/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.injection;

import java.util.HashMap;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.extras.injection.AbstractSocialInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceInjector
extends AbstractSocialInjector {
    private static final String NUMBER = "number";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String USER_PREFIX = "userPrefix";
    private static final String SPACE_PREFIX = "spacePrefix";

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        int from = this.param(params, FROM_USER);
        int to = this.param(params, TO_USER);
        String userPrefix = params.get(USER_PREFIX);
        String spacePrefix = params.get(SPACE_PREFIX);
        this.init(userPrefix, spacePrefix);
        for (int i = from; i <= to; ++i) {
            for (int j = 0; j < number; ++j) {
                String owner = this.userBase + i;
                String spaceName = this.spaceName();
                Space space = new Space();
                space.setDisplayName(spaceName);
                space.setPrettyName(spaceName);
                space.setGroupId("/spaces/" + space.getPrettyName());
                space.setRegistration("open");
                space.setDescription(this.lorem.getWords(10));
                space.setType("classic");
                space.setVisibility("private");
                space.setRegistration("open");
                space.setPriority("2");
                this.spaceService.createSpace(space, owner);
                ++this.spaceNumber;
                SpaceUtils.endRequest();
                this.getLog().info((Object)("Space " + spaceName + " created by " + owner));
            }
        }
    }
}

