/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.migration.rw;

import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.social.extras.migration.MigrationException;
import org.exoplatform.social.extras.migration.io.NodeStreamHandler;
import org.exoplatform.social.extras.migration.io.WriterContext;
import org.exoplatform.social.extras.migration.rw.NodeReader;

public class NodeReader_11x_12x
implements NodeReader {
    private Session session;
    private Node rootNode;
    private NodeStreamHandler writer;

    public NodeReader_11x_12x(Session session) throws RepositoryException {
        this.session = session;
        this.rootNode = session.getRootNode();
        this.writer = new NodeStreamHandler();
    }

    public void readIdentities(OutputStream os, WriterContext ctx) throws RepositoryException, IOException {
        this.run(new IdentityRunnable(os, ctx));
    }

    public void readSpaces(OutputStream os, WriterContext ctx) throws RepositoryException, IOException {
        this.run(new SpaceRunnable(os, ctx));
    }

    public void readProfiles(OutputStream os, WriterContext ctx) throws RepositoryException, IOException {
        this.run(new ProfileRunnable(os, ctx));
    }

    public void readActivities(OutputStream os, WriterContext ctx) throws RepositoryException, IOException {
        this.run(new ActivityRunnable(os, ctx));
    }

    public void readRelationships(OutputStream os, WriterContext ctx) throws RepositoryException, IOException {
        this.run(new RelationshipRunnable(os, ctx));
    }

    private void readFrom(NodeIterator nodes, OutputStream os) throws RepositoryException, IOException {
        while (nodes.hasNext()) {
            this.writer.writeNode((Node)nodes.next(), os);
        }
    }

    public void checkData() throws MigrationException {
        try {
            this.rootNode.getNode("exo:applications");
        }
        catch (RepositoryException e) {
            throw new MigrationException("No data found for this version");
        }
    }

    private void run(Runnable r) {
        new Thread(r).start();
    }

    class ProfileRunnable
    implements Runnable {
        private OutputStream os;
        private WriterContext ctx;

        ProfileRunnable(OutputStream os, WriterContext ctx) {
            this.os = os;
            this.ctx = ctx;
        }

        public void run() {
            try {
                if (!NodeReader_11x_12x.this.rootNode.hasNode("exo:applications/Social_Profile")) {
                    this.os.close();
                    return;
                }
                Node rootProfile = NodeReader_11x_12x.this.rootNode.getNode("exo:applications/Social_Profile");
                NodeIterator it = rootProfile.getNodes();
                it.skip(this.ctx.getDone(WriterContext.DataType.PROFILES).longValue());
                while (it.hasNext()) {
                    Node currentProfile = it.nextNode();
                    NodeReader_11x_12x.this.writer.writeNode(currentProfile, this.os);
                    NodeIterator profileDetail = currentProfile.getNodes();
                    while (profileDetail.hasNext()) {
                        NodeReader_11x_12x.this.writer.writeNode(profileDetail.nextNode(), this.os);
                    }
                }
                this.os.close();
            }
            catch (Exception e) {
                throw new MigrationException(e);
            }
        }
    }

    class ActivityRunnable
    implements Runnable {
        private OutputStream os;
        private WriterContext ctx;

        ActivityRunnable(OutputStream os, WriterContext ctx) {
            this.os = os;
            this.ctx = ctx;
        }

        public void run() {
            long remaining = this.ctx.getDone(WriterContext.DataType.ACTIVITIES);
            try {
                long size;
                NodeIterator it;
                Node publishedNode;
                Node currentUser;
                if (NodeReader_11x_12x.this.rootNode.hasNode("exo:applications/Social_Activity/organization")) {
                    Node rootOrganizationActivity = NodeReader_11x_12x.this.rootNode.getNode("exo:applications/Social_Activity/organization");
                    NodeIterator userItOrganization = rootOrganizationActivity.getNodes();
                    while (userItOrganization.hasNext()) {
                        currentUser = userItOrganization.nextNode();
                        publishedNode = currentUser.getNode("published");
                        it = publishedNode.getNodes();
                        size = it.getSize();
                        if (remaining >= size) {
                            remaining -= size;
                            continue;
                        }
                        if (remaining > 0L) {
                            it.skip(remaining);
                            NodeReader_11x_12x.this.readFrom(it, this.os);
                            remaining = 0L;
                            continue;
                        }
                        NodeReader_11x_12x.this.readFrom(it, this.os);
                    }
                }
                if (!NodeReader_11x_12x.this.rootNode.hasNode("exo:applications/Social_Activity/space")) {
                    this.os.close();
                    return;
                }
                Node rootSpaceActivity = NodeReader_11x_12x.this.rootNode.getNode("exo:applications/Social_Activity/space");
                NodeIterator userItSpace = rootSpaceActivity.getNodes();
                while (userItSpace.hasNext()) {
                    currentUser = userItSpace.nextNode();
                    publishedNode = currentUser.getNode("published");
                    it = publishedNode.getNodes();
                    size = it.getSize();
                    if (remaining >= size) {
                        remaining -= size;
                        continue;
                    }
                    if (remaining > 0L) {
                        it.skip(remaining);
                        NodeReader_11x_12x.this.readFrom(it, this.os);
                        remaining = 0L;
                        continue;
                    }
                    NodeReader_11x_12x.this.readFrom(it, this.os);
                }
                this.os.close();
            }
            catch (Exception e) {
                throw new MigrationException(e);
            }
        }
    }

    class SpaceRunnable
    implements Runnable {
        private OutputStream os;
        private WriterContext ctx;

        SpaceRunnable(OutputStream os, WriterContext ctx) {
            this.os = os;
            this.ctx = ctx;
        }

        public void run() {
            try {
                if (!NodeReader_11x_12x.this.rootNode.hasNode("exo:applications/Social_Space/Space")) {
                    this.os.close();
                    return;
                }
                Node rootSpace = NodeReader_11x_12x.this.rootNode.getNode("exo:applications/Social_Space/Space");
                NodeIterator it = rootSpace.getNodes();
                it.skip(this.ctx.getDone(WriterContext.DataType.SPACES).longValue());
                NodeReader_11x_12x.this.readFrom(it, this.os);
                this.os.close();
            }
            catch (Exception e) {
                throw new MigrationException(e);
            }
        }
    }

    class RelationshipRunnable
    implements Runnable {
        private OutputStream os;
        private WriterContext ctx;

        RelationshipRunnable(OutputStream os, WriterContext ctx) {
            this.os = os;
            this.ctx = ctx;
        }

        public void run() {
            try {
                if (!NodeReader_11x_12x.this.rootNode.hasNode("exo:applications/Social_Relationship")) {
                    this.os.close();
                    return;
                }
                Node rootRelationship = NodeReader_11x_12x.this.rootNode.getNode("exo:applications/Social_Relationship");
                NodeIterator it = rootRelationship.getNodes();
                it.skip(this.ctx.getDone(WriterContext.DataType.RELATIONSHIPS).longValue());
                NodeReader_11x_12x.this.readFrom(it, this.os);
                this.os.close();
            }
            catch (Exception e) {
                throw new MigrationException(e);
            }
        }
    }

    class IdentityRunnable
    implements Runnable {
        private OutputStream os;
        private WriterContext ctx;

        IdentityRunnable(OutputStream os, WriterContext ctx) {
            this.os = os;
            this.ctx = ctx;
        }

        public void run() {
            try {
                if (!NodeReader_11x_12x.this.rootNode.hasNode("exo:applications/Social_Identity")) {
                    this.os.close();
                    return;
                }
                Node rootIdentity = NodeReader_11x_12x.this.rootNode.getNode("exo:applications/Social_Identity");
                NodeIterator it = rootIdentity.getNodes();
                it.skip(this.ctx.getDone(WriterContext.DataType.IDENTITIES).longValue());
                NodeReader_11x_12x.this.readFrom(it, this.os);
                this.os.close();
            }
            catch (Exception e) {
                throw new MigrationException(e);
            }
        }
    }
}

