/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.samples.feedmash;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import java.util.Date;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.extras.feedmash.AbstractFeedmashJob;
import org.exoplatform.social.extras.feedmash.Application;
import org.quartz.JobDataMap;

public class HudsonFeedConsumer
extends AbstractFeedmashJob {
    private static final Log LOG = ExoLogger.getLogger(HudsonFeedConsumer.class);
    private static final String HUDSON_STATUS = "status";
    private String successIcon = "/eXoResources/skin/DefaultSkin/skinIcons/16x16/icons/GreenFlag.gif";
    private String failureIcon = "/eXoResources/skin/DefaultSkin/skinIcons/16x16/icons/RedFlag.gif";
    private String hudsonLogo = "http://wiki.hudson-ci.org/download/attachments/2916393/banner-100.png?version=1&modificationDate=1185846429000";
    private String baseUrl;
    private String project;

    protected boolean accept(SyndEntryImpl entry) {
        if (this.alreadyChecked(entry.getUpdatedDate())) {
            return false;
        }
        String currentStatus = (String)this.getState(HUDSON_STATUS);
        if (currentStatus == null) {
            return true;
        }
        if (currentStatus.equals(BuildStatus.FAILURE.name())) {
            return entry.getTitle().contains(BuildStatus.SUCCESS.name());
        }
        return entry.getTitle().contains(BuildStatus.FAILURE.name());
    }

    protected void handle(SyndEntryImpl entry) {
        try {
            Identity targetStream = this.getIdentity(this.targetActivityStream);
            if (targetStream == null) {
                return;
            }
            String currentStatus = this.currentStatus(entry);
            LOG.debug((Object)("Publishing " + currentStatus + " on : " + targetStream.getRemoteId() + " stream"));
            String message = this.message(currentStatus, entry.getLink(), entry.getTitle());
            Identity hudson = this.getHudsonIdentity();
            this.publishActivity(message, hudson, targetStream);
            this.saveState(HUDSON_STATUS, currentStatus);
            this.saveState("lastChecked", new Date());
        }
        catch (Exception e) {
            LOG.error((Object)("failed to publish hudson activity: " + e.getMessage()), (Throwable)e);
        }
    }

    public void beforeJobExecute(JobDataMap dataMap) {
        this.successIcon = this.getStringParam(dataMap, "successIcon", this.successIcon);
        this.failureIcon = this.getStringParam(dataMap, "failureIcon", this.failureIcon);
        this.baseUrl = this.getStringParam(dataMap, "baseURL", null);
        this.project = this.getStringParam(dataMap, "project", null);
        if (this.feedUrl == null) {
            this.feedUrl = this.baseUrl + "/job/" + this.project + "/rssAll";
        }
    }

    private String currentStatus(SyndEntryImpl entry) {
        String currentStatus = entry.getTitle().contains(BuildStatus.SUCCESS.name()) ? BuildStatus.SUCCESS.name() : BuildStatus.FAILURE.name();
        return currentStatus;
    }

    private String message(String status, String link, String title) {
        String icon = status == BuildStatus.SUCCESS.name() ? this.successIcon : this.failureIcon;
        return "<img src=\"" + icon + "\" alt=\"failure\" title=\"failure\" />&nbsp;<a href=\"" + link + "\">" + title + "</a>";
    }

    private Identity getHudsonIdentity() throws Exception {
        return this.getAppIdentity(this.hudsonApp());
    }

    private Application hudsonApp() {
        Application application = new Application();
        application.setId("Hudson-" + this.project);
        application.setName("Hudson (" + this.project + ")");
        String url = this.baseUrl + "/job/" + this.project;
        application.setIcon(this.hudsonLogo);
        application.setUrl(url);
        return application;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BuildStatus {
        FAILURE,
        SUCCESS;

    }
}

