/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.samples.feedmash;

import com.sun.syndication.feed.synd.SyndCategoryImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.extras.feedmash.AbstractFeedmashJob;
import org.exoplatform.social.extras.feedmash.Application;
import org.quartz.JobDataMap;

public class JiraFeedConsumer
extends AbstractFeedmashJob {
    private static final Log LOG = ExoLogger.getLogger(JiraFeedConsumer.class);
    private String jiraLogo = "http://www.meta-inf.hu/images/atlassian/logo-jira.gif";
    private String baseUrl;
    private String project;
    private String categoryMatch;

    protected boolean accept(SyndEntryImpl entry) {
        if (this.alreadyChecked(entry.getUpdatedDate())) {
            return false;
        }
        List cats = entry.getCategories();
        for (SyndCategoryImpl category : cats) {
            if (!category.getName().matches(this.categoryMatch)) continue;
            return true;
        }
        return false;
    }

    protected void handle(SyndEntryImpl entry) {
        try {
            LOG.debug((Object)("republishing jira activity on : " + this.targetActivityStream + " stream, entry uri: " + entry.getLink()));
            Identity jira = this.getJiraIdentity();
            Identity space = this.getIdentity(this.targetActivityStream);
            if (space == null) {
                return;
            }
            String message = entry.getTitle();
            this.publishActivity(message, jira, space);
        }
        catch (Exception e) {
            LOG.error((Object)("failed to republish jira activity: " + e.getMessage()), (Throwable)e);
        }
    }

    public void beforeJobExecute(JobDataMap dataMap) {
        this.baseUrl = this.getStringParam(dataMap, "baseURL", null);
        this.project = this.getStringParam(dataMap, "project", null);
        if (this.feedUrl == null) {
            this.feedUrl = this.baseUrl + "/plugins/servlet/streams?key=" + this.project;
        }
        this.categoryMatch = dataMap.getString("categoryMatch");
    }

    private Identity getJiraIdentity() throws Exception {
        Application jiraApp = this.jiraApp();
        return this.getAppIdentity(jiraApp);
    }

    private Application jiraApp() {
        Application application = new Application();
        application.setId("jira-" + this.project);
        application.setName("JIRA (" + this.project + ")");
        String url = this.baseUrl + "/browse/" + this.project;
        application.setUrl(url);
        application.setIcon(this.jiraLogo);
        return application;
    }
}

