/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting.rmi;

import java.io.IOException;
import java.rmi.MarshalledObject;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.rmi.RMIConnection;
import javax.security.auth.Subject;
import org.jboss.mx.remoting.rmi.ClientListenerHolder;
import org.jboss.mx.remoting.rmi.ClientNotifier;

public class ClientMBeanServerConnection
implements MBeanServerConnection {
    private RMIConnection connection = null;
    private Subject subject = null;
    private transient ClassLoader defaultClassLoader = null;
    private ClientNotifier clientNotifier = null;

    public ClientMBeanServerConnection(RMIConnection rmiConnection, ClientNotifier clientNotifier, ClassLoader classLoader, Subject subject) {
        this.connection = rmiConnection;
        this.clientNotifier = clientNotifier;
        this.defaultClassLoader = classLoader;
        this.subject = subject;
    }

    private ClassLoader activateDefaultClassLoader() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.defaultClassLoader);
        return current;
    }

    private void deActivateDefaultClassLoader(ClassLoader previousClassLoader) {
        Thread.currentThread().setContextClassLoader(previousClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            ObjectInstance objectInstance = this.connection.createMBean(className, name, this.subject);
            return objectInstance;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            ObjectInstance objectInstance = this.connection.createMBean(className, name, loaderName, this.subject);
            return objectInstance;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        MarshalledObject<Object[]> args = new MarshalledObject<Object[]>(params);
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            ObjectInstance objectInstance = this.connection.createMBean(className, name, args, signature, this.subject);
            return objectInstance;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        MarshalledObject<Object[]> args = new MarshalledObject<Object[]>(params);
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            ObjectInstance objectInstance = this.connection.createMBean(className, name, loaderName, args, signature, this.subject);
            return objectInstance;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            this.connection.unregisterMBean(name, this.subject);
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            ObjectInstance objectInstance = this.connection.getObjectInstance(name, this.subject);
            return objectInstance;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
        MarshalledObject<QueryExp> args = new MarshalledObject<QueryExp>(query);
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            Set set = this.connection.queryMBeans(name, args, this.subject);
            return set;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryNames(ObjectName name, QueryExp query) throws IOException {
        MarshalledObject<QueryExp> args = new MarshalledObject<QueryExp>(query);
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            Set set = this.connection.queryNames(name, args, this.subject);
            return set;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ObjectName name) throws IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            boolean bl = this.connection.isRegistered(name, this.subject);
            return bl;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getMBeanCount() throws IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            Integer n = this.connection.getMBeanCount(this.subject);
            return n;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            Object object = this.connection.getAttribute(name, attribute, this.subject);
            return object;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            AttributeList attributeList = this.connection.getAttributes(name, attributes, this.subject);
            return attributeList;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        MarshalledObject<Attribute> args = new MarshalledObject<Attribute>(attribute);
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            this.connection.setAttribute(name, args, this.subject);
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        MarshalledObject<AttributeList> args = new MarshalledObject<AttributeList>(attributes);
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            AttributeList attributeList = this.connection.setAttributes(name, args, this.subject);
            return attributeList;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        MarshalledObject<Object[]> args = new MarshalledObject<Object[]>(params);
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            Object object = this.connection.invoke(name, operationName, args, signature, this.subject);
            return object;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultDomain() throws IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            String string = this.connection.getDefaultDomain(this.subject);
            return string;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDomains() throws IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            String[] stringArray = this.connection.getDomains(this.subject);
            return stringArray;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        ClientListenerHolder holder = new ClientListenerHolder(name, listener, filter, handback);
        if (this.clientNotifier.exists(holder)) {
            return;
        }
        MarshalledObject<NotificationFilter> marshalledFilter = null;
        if (filter != null) {
            try {
                marshalledFilter = new MarshalledObject<NotificationFilter>(filter);
            }
            catch (IOException e) {
                holder.setFilterOnClient(true);
            }
        }
        Integer[] listenerIDs = this.connection.addNotificationListeners(new ObjectName[]{name}, new MarshalledObject[]{marshalledFilter}, new Subject[]{this.subject});
        this.clientNotifier.addNotificationListener(listenerIDs[0], holder);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        MarshalledObject<NotificationFilter> marshalledFilter = filter != null ? new MarshalledObject<NotificationFilter>(filter) : null;
        MarshalledObject<Object> marshalledHandback = handback != null ? new MarshalledObject<Object>(handback) : null;
        this.connection.addNotificationListener(name, listener, marshalledFilter, marshalledHandback, this.subject);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.connection.removeNotificationListener(name, listener, this.subject);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        MarshalledObject<NotificationFilter> marshalledFilter = filter != null ? new MarshalledObject<NotificationFilter>(filter) : null;
        MarshalledObject<Object> marshalledHandback = handback != null ? new MarshalledObject<Object>(handback) : null;
        this.connection.removeNotificationListener(name, listener, marshalledFilter, marshalledHandback, this.subject);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Integer[] ids = this.clientNotifier.getListeners(name, listener);
        if (ids == null || ids.length == 0) {
            throw new ListenerNotFoundException("Listener (" + listener + ") not found as a registered listener.");
        }
        this.connection.removeNotificationListeners(name, ids, this.subject);
        this.clientNotifier.removeListeners(ids);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        Integer id = this.clientNotifier.getListener(new ClientListenerHolder(name, listener, filter, handback));
        if (id == null) {
            throw new ListenerNotFoundException("Listener (" + listener + ") could not be found as registered listener.");
        }
        Integer[] ids = new Integer[]{id};
        this.connection.removeNotificationListeners(name, ids, this.subject);
        this.clientNotifier.removeListeners(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            MBeanInfo mBeanInfo = this.connection.getMBeanInfo(name, this.subject);
            return mBeanInfo;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        ClassLoader current = this.activateDefaultClassLoader();
        try {
            boolean bl = this.connection.isInstanceOf(name, className, this.subject);
            return bl;
        }
        finally {
            this.deActivateDefaultClassLoader(current);
        }
    }
}

