/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting.tracker;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.JMXUtil;
import org.jboss.mx.remoting.MBeanLocator;
import org.jboss.mx.remoting.MBeanServerLocator;
import org.jboss.mx.remoting.event.ClassQueryExp;
import org.jboss.mx.remoting.event.CompositeEventFilter;
import org.jboss.mx.remoting.event.CompositeQueryExp;
import org.jboss.mx.remoting.tracker.MBeanTrackerAction;
import org.jboss.mx.remoting.tracker.MBeanTrackerFilter;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkInstance;
import org.jboss.remoting.network.NetworkNotification;
import org.jboss.remoting.network.NetworkRegistryFinder;
import org.jboss.remoting.network.NetworkRegistryMBean;

public class MBeanTracker
implements NotificationListener {
    private static final boolean logEvents = Boolean.getBoolean("jboss.mx.tracker.debug");
    private static final transient Logger log = Logger.getLogger((String)MBeanTracker.class.getName());
    private final QueryExp query;
    private final boolean localOnly;
    private final boolean wantNotifications;
    private final NotificationFilter filter;
    private final SynchronizedInt count = new SynchronizedInt(0);
    private final Map mbeans = new HashMap();
    private final String[] classes;
    private final List actions = new ArrayList(1);
    private final ObjectName networkRegistry;
    private final MBeanServer myserver;

    public MBeanTracker(MBeanServer myserver, Class[] cl, QueryExp query, boolean localOnly, MBeanTrackerAction action) throws Exception {
        this(myserver, cl, query, localOnly, null, false, new MBeanTrackerAction[]{action});
    }

    public MBeanTracker(MBeanServer myserver, Class[] cl, QueryExp query, boolean localOnly, MBeanTrackerAction[] actions) throws Exception {
        this(myserver, cl, query, localOnly, null, false, actions);
    }

    public MBeanTracker(MBeanServer myserver, Class[] cl, boolean localOnly, MBeanTrackerAction action) throws Exception {
        this(myserver, cl, null, localOnly, null, false, new MBeanTrackerAction[]{action});
    }

    public MBeanTracker(MBeanServer myserver, Class[] cl, boolean localOnly, MBeanTrackerAction[] actions) throws Exception {
        this(myserver, cl, null, localOnly, null, false, actions);
    }

    public MBeanTracker(MBeanServer myserver, Class[] cl, QueryExp query, boolean localOnly, NotificationFilter filter, boolean wantNotifications, MBeanTrackerAction action) throws Exception {
        this(myserver, cl, query, localOnly, filter, wantNotifications, new MBeanTrackerAction[]{action});
    }

    public MBeanTracker(MBeanServer myserver, Class[] cl, QueryExp query, boolean localOnly, NotificationFilter filter, boolean wantNotifications) throws Exception {
        this(myserver, cl, query, localOnly, filter, wantNotifications, (MBeanTrackerAction[])null);
    }

    public MBeanTracker(MBeanServer myserver, Class[] cl, QueryExp query, boolean localOnly, NotificationFilter filter, boolean wantNotifications, MBeanTrackerAction[] actions) throws Exception {
        int c;
        this.localOnly = localOnly;
        this.wantNotifications = wantNotifications;
        this.filter = filter;
        this.myserver = myserver;
        if (log.isTraceEnabled()) {
            StringBuffer buf = new StringBuffer("creating an MBeanTracker with the following parameters:\n");
            buf.append("==========================================\n");
            buf.append("MBeanServer:   " + myserver + "\n");
            if (cl == null) {
                buf.append("classes: none\n");
            } else {
                for (c = 0; c < cl.length; ++c) {
                    buf.append("classes[" + c + "] " + cl[c].getName() + "\n");
                }
            }
            log.debug((Object)("QueryExp:       " + query + "\n"));
            log.debug((Object)("localOnly:      " + localOnly + "\n"));
            log.debug((Object)("filter:         " + filter + "\n"));
            log.debug((Object)("notifications:  " + wantNotifications + "\n"));
            if (actions == null) {
                log.debug((Object)"actions: none\n");
            } else {
                for (c = 0; c < actions.length; ++c) {
                    log.debug((Object)("actions[" + c + "]: " + actions[c] + "\n"));
                }
            }
            buf.append("==========================================\n");
            log.debug((Object)buf.toString());
        }
        if (actions != null) {
            for (int c2 = 0; c2 < actions.length; ++c2) {
                if (actions[c2] == null) continue;
                this.addActionListener(actions[c2]);
            }
        }
        if (cl != null) {
            this.classes = new String[cl.length];
            for (int c3 = 0; c3 < cl.length; ++c3) {
                this.classes[c3] = cl[c3].getName();
            }
        } else {
            this.classes = null;
        }
        this.query = query == null && cl != null ? new ClassQueryExp(cl) : (cl != null ? new CompositeQueryExp(new QueryExp[]{new ClassQueryExp(cl, 2), query}) : query);
        this.networkRegistry = NetworkRegistryFinder.find((MBeanServer)myserver);
        if (this.networkRegistry == null) {
            throw new Exception("NetworkRegistryMBean not found - MBeanTracker has a dependency on this MBean");
        }
        this.foundMBeanServer(new MBeanServerLocator(Identity.get((MBeanServer)myserver)));
        if (!this.localOnly) {
            myserver.addNotificationListener(this.networkRegistry, this, null, null);
            NetworkInstance[] instances = (NetworkInstance[])myserver.getAttribute(this.networkRegistry, "Servers");
            if (instances != null) {
                for (c = 0; c < instances.length; ++c) {
                    this.foundMBeanServer(new MBeanServerLocator(instances[c].getIdentity()));
                }
            }
        }
    }

    public void addActionListener(MBeanTrackerAction action) {
        this.addActionListener(action, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(MBeanTrackerAction action, boolean autoinitialregister) {
        if (log.isTraceEnabled()) {
            log.debug((Object)("adding action: " + action + ", autoinitialregister:" + autoinitialregister));
        }
        List list = this.actions;
        synchronized (list) {
            this.actions.add(action);
        }
        if (autoinitialregister) {
            Set set = this.getMBeans();
            for (MBeanLocator locator : set) {
                this.fireRegister(locator);
            }
        }
    }

    public void removeActionListener(MBeanTrackerAction action) {
        if (log.isTraceEnabled()) {
            log.debug((Object)("removing action: " + action));
        }
        Iterator iter = this.actions();
        while (iter.hasNext()) {
            MBeanTrackerAction _action = (MBeanTrackerAction)iter.next();
            if (!_action.equals(action)) continue;
            iter.remove();
        }
    }

    private NotificationFilter createFilterForServer(String id) {
        NotificationFilter serverfilter = null;
        MBeanTrackerFilter nfilter = new MBeanTrackerFilter(id, this.classes, this.wantNotifications);
        serverfilter = this.filter == null ? nfilter : new CompositeEventFilter(new NotificationFilter[]{nfilter, this.filter});
        return serverfilter;
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public void destroy() {
        if (log.isTraceEnabled()) {
            log.debug((Object)"destroy");
        }
        try {
            this.myserver.removeNotificationListener(this.networkRegistry, this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final boolean isEmpty() {
        return this.count() <= 0;
    }

    public final int count() {
        return this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set getMBeans() {
        HashSet set = new HashSet();
        Map map = this.mbeans;
        synchronized (map) {
            for (Set beans : this.mbeans.values()) {
                set.addAll(beans);
            }
        }
        return set;
    }

    public final Iterator iterator() {
        return this.getMBeans().iterator();
    }

    private void tryAddListener(MBeanServerLocator server, ObjectName mbean) {
        try {
            if (server.getMBeanServer().isInstanceOf(mbean, NotificationBroadcaster.class.getName()) && !server.getMBeanServer().isInstanceOf(mbean, NetworkRegistryMBean.class.getName())) {
                server.getMBeanServer().addNotificationListener(mbean, this, this.createFilterForServer(server.getServerId()), (Object)server);
                if (log.isTraceEnabled()) {
                    log.debug((Object)("added notification listener to: " + mbean + " on server: " + server));
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)("Error registering listener for server:" + server + " and mbean:" + mbean), e);
        }
    }

    private void tryRemoveListener(MBeanServerLocator server, ObjectName mbean) {
        try {
            if (server.getMBeanServer() == null) {
                return;
            }
            if (server.getMBeanServer().isInstanceOf(mbean, NotificationBroadcaster.class.getName()) && !server.getMBeanServer().isInstanceOf(mbean, NetworkRegistryMBean.class.getName())) {
                server.getMBeanServer().removeNotificationListener(mbean, this);
                if (log.isTraceEnabled()) {
                    log.debug((Object)("removed notification listener to: " + mbean + " on server: " + server));
                }
            }
        }
        catch (InstanceNotFoundException nf) {
        }
        catch (ConnectionFailedException cnf) {
        }
        catch (Exception e) {
            MBeanException mbe;
            MBeanException mbe2;
            ReflectionException re;
            UndeclaredThrowableException ut;
            if (e instanceof UndeclaredThrowableException && ((ut = (UndeclaredThrowableException)e).getUndeclaredThrowable() instanceof ReflectionException ? (re = (ReflectionException)ut.getUndeclaredThrowable()).getTargetException() instanceof InstanceNotFoundException || re.getTargetException() instanceof ConnectionFailedException : ut.getUndeclaredThrowable() instanceof MBeanException && (mbe2 = (MBeanException)ut.getUndeclaredThrowable()).getTargetException() instanceof ConnectionFailedException)) {
                return;
            }
            if (e instanceof MBeanException && (mbe = (MBeanException)e).getTargetException() instanceof ConnectionFailedException) {
                return;
            }
            log.warn((Object)("Error removing listener for server:" + server + " and mbean:" + mbean), (Throwable)e);
        }
    }

    public void handleNotification(Notification notification, Object o) {
        if (log.isTraceEnabled()) {
            log.debug((Object)("tracker received notification=" + notification + " with handback=" + o));
        }
        try {
            MBeanServerLocator server;
            AttributeChangeNotification ch;
            if (notification instanceof MBeanServerNotification && JMXUtil.getMBeanServerObjectName().equals(notification.getSource())) {
                MBeanServerNotification n = (MBeanServerNotification)notification;
                String type = n.getType();
                ObjectName mbean = n.getMBeanName();
                if (type.equals("JMX.mbean.registered")) {
                    this.addMBean((MBeanServerLocator)o, mbean);
                } else {
                    this.removeMBean((MBeanServerLocator)o, mbean);
                }
                return;
            }
            if (notification instanceof NetworkNotification) {
                NetworkNotification nn = (NetworkNotification)notification;
                String type = nn.getType();
                if (type.equals("jboss.network.server.added")) {
                    Identity ident = nn.getIdentity();
                    MBeanServerLocator l = new MBeanServerLocator(ident);
                    this.foundMBeanServer(l);
                } else if (type.equals("jboss.network.server.removed")) {
                    Identity ident = nn.getIdentity();
                    MBeanServerLocator l = new MBeanServerLocator(ident);
                    this.lostMBeanServer(l);
                }
                return;
            }
            if (notification instanceof AttributeChangeNotification && (ch = (AttributeChangeNotification)notification).getAttributeName().equals("State") && this.hasActions()) {
                MBeanServerLocator server2 = (MBeanServerLocator)o;
                Object src = ch.getSource();
                if (src instanceof ObjectName) {
                    ObjectName obj = (ObjectName)src;
                    this.fireStateChange(new MBeanLocator(server2, obj), (Integer)ch.getOldValue(), (Integer)ch.getNewValue());
                    return;
                }
                if (src instanceof MBeanLocator) {
                    this.fireNotification((MBeanLocator)src, notification, o);
                    return;
                }
            }
            if (this.wantNotifications && this.hasActions() && (server = (MBeanServerLocator)o) != null) {
                Object src = notification.getSource();
                if (src instanceof ObjectName) {
                    ObjectName obj = (ObjectName)src;
                    MBeanLocator locator = new MBeanLocator(server, obj);
                    this.fireNotification(locator, notification, o);
                    return;
                }
                if (src instanceof MBeanLocator) {
                    this.fireNotification((MBeanLocator)src, notification, o);
                    return;
                }
                log.debug((Object)("Unknown source type for notification: " + src));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error encountered receiving notification: " + notification), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasActions() {
        List list = this.actions;
        synchronized (list) {
            return !this.actions.isEmpty();
        }
    }

    protected void fireNotification(MBeanLocator locator, Notification n, Object o) {
        Iterator iter = this.actions();
        while (iter.hasNext()) {
            MBeanTrackerAction action = (MBeanTrackerAction)iter.next();
            if (this.wantNotifications && log.isTraceEnabled()) {
                log.debug((Object)("forwarding tracker notification: " + n + " to action: " + action + " for tracker: " + this));
            }
            action.mbeanNotification(locator, n, o);
        }
    }

    protected void fireStateChange(MBeanLocator locator, int ov, int nv) {
        Iterator iter = this.actions();
        while (iter.hasNext()) {
            MBeanTrackerAction action = (MBeanTrackerAction)iter.next();
            if (this.wantNotifications && log.isTraceEnabled()) {
                log.debug((Object)("forwarding tracker state change: " + nv + " [" + ov + "] to action: " + action + " for tracker: " + this));
            }
            action.mbeanStateChanged(locator, ov, nv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Iterator actions() {
        List list = this.actions;
        synchronized (list) {
            if (this.actions.isEmpty()) {
                return Collections.EMPTY_LIST.iterator();
            }
            return new ArrayList(this.actions).iterator();
        }
    }

    protected void fireUnregister(MBeanLocator locator) {
        int c = 0;
        Iterator iter = this.actions();
        while (iter.hasNext()) {
            MBeanTrackerAction action = (MBeanTrackerAction)iter.next();
            if (logEvents && log.isTraceEnabled()) {
                log.debug((Object)("firing unregister to action [" + ++c + "] => " + action + " for locator => " + locator));
            }
            action.mbeanUnregistered(locator);
        }
    }

    protected void fireRegister(MBeanLocator locator) {
        int c = 0;
        Iterator iter = this.actions();
        while (iter.hasNext()) {
            MBeanTrackerAction action = (MBeanTrackerAction)iter.next();
            if (logEvents && log.isTraceEnabled()) {
                log.debug((Object)("firing register to action [" + ++c + "] => " + action + " for locator => " + locator));
            }
            action.mbeanRegistered(locator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void foundMBeanServer(MBeanServerLocator theserver) {
        Map map = this.mbeans;
        synchronized (map) {
            if (this.mbeans.containsKey(theserver)) {
                return;
            }
            this.mbeans.put(theserver, new HashSet());
        }
        for (int c = 0; c < 3; ++c) {
            try {
                theserver.getMBeanServer().addNotificationListener(JMXUtil.getMBeanServerObjectName(), this, this.createFilterForServer(theserver.getServerId()), (Object)theserver);
                Set<ObjectInstance> beans = theserver.getMBeanServer().queryMBeans(new ObjectName("*:*"), this.query);
                if (!beans.isEmpty()) {
                    Iterator<ObjectInstance> iter = beans.iterator();
                    while (iter.hasNext()) {
                        this.addMBean(theserver, iter.next().getObjectName());
                    }
                    break;
                }
                if (!log.isTraceEnabled()) break;
                log.debug((Object)("Queried server: " + theserver + ", but found 0 mbeans matching query"));
                break;
            }
            catch (ConnectionFailedException ce) {
                if (log.isTraceEnabled()) {
                    log.debug((Object)("while trying to add a listener and get info for: " + theserver + ", i lost it"), (Throwable)ce);
                }
                if (c < 3) continue;
                if (log.isTraceEnabled()) {
                    log.debug((Object)("giving up on connection failed after " + c + " attempts... " + theserver));
                }
                this.lostMBeanServer(theserver);
                continue;
            }
            catch (Exception ex) {
                log.warn((Object)("Exception adding mbeans from server: " + theserver), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMBean(MBeanServerLocator server, ObjectName mbean) {
        if (log.isTraceEnabled()) {
            log.debug((Object)("addMBean called: " + server + ", mbean: " + mbean));
        }
        MBeanLocator locator = new MBeanLocator(server, mbean);
        boolean found = false;
        Map map = this.mbeans;
        synchronized (map) {
            Set set = (Set)this.mbeans.get(server);
            if (set != null && set.add(locator)) {
                this.count.increment();
                found = true;
            }
        }
        if (!found) {
            return;
        }
        this.tryAddListener(server, mbean);
        if (this.hasActions()) {
            this.fireRegister(locator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMBean(MBeanServerLocator server, ObjectName mbean) {
        if (log.isTraceEnabled()) {
            log.debug((Object)("removeMBean called: " + server + ", mbean: " + mbean));
        }
        MBeanLocator locator = new MBeanLocator(server, mbean);
        Map map = this.mbeans;
        synchronized (map) {
            Set set = (Set)this.mbeans.get(server);
            if (set != null) {
                if (set.remove(locator)) {
                    this.count.decrement();
                } else {
                    return;
                }
            }
        }
        this.tryRemoveListener(server, mbean);
        if (this.hasActions()) {
            this.fireUnregister(locator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostMBeanServer(MBeanServerLocator server) {
        if (this.wantNotifications && log.isTraceEnabled()) {
            log.debug((Object)("lostMBeanServer: " + server + " for tracker: " + this));
        }
        Set list = null;
        Map map = this.mbeans;
        synchronized (map) {
            list = (Set)this.mbeans.remove(server);
        }
        if (list != null) {
            if (log.isTraceEnabled()) {
                log.debug((Object)("lost mbean server = " + server + ", list = " + list));
            }
            for (MBeanLocator locator : list) {
                this.removeMBean(server, locator.getObjectName());
            }
            list.clear();
            list = null;
        }
    }
}

