/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration.definition;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;

@Entity
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CONFIG_TEMPLATE_ID_SEQ")
@Table(name="RHQ_CONFIG_TEMPLATE")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConfigurationTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_TEMPLATE_NAME = "default";
    @GeneratedValue(generator="SEQ", strategy=GenerationType.SEQUENCE)
    @Id
    private int id;
    @Column(name="name")
    private String name;
    @Column(name="description")
    private String description;
    @JoinColumn(name="config_id")
    @OneToOne(optional=false, cascade={CascadeType.ALL})
    private Configuration configuration;
    @JoinColumn(name="config_def_id")
    @ManyToOne
    @XmlTransient
    private ConfigurationDefinition configurationDefinition;
    @Column(name="is_default")
    private boolean isDefault;

    protected ConfigurationTemplate() {
    }

    public ConfigurationTemplate(@NotNull String name, @Nullable String description) {
        this.name = name;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public ConfigurationDefinition getConfigurationDefinition() {
        return this.configurationDefinition;
    }

    public void setConfigurationDefinition(ConfigurationDefinition configurationDefinition) {
        this.configurationDefinition = configurationDefinition;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Configuration createConfiguration() {
        return this.getConfiguration().deepCopy(false);
    }

    public String toString() {
        return "ConfigurationTemplate[id=" + this.id + ", name=" + this.name + (this.configurationDefinition != null ? ", config=" + this.configurationDefinition.getName() : "") + "]";
    }
}

