/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement.calltime;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeDataValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallTimeData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(CallTimeData.class);
    private int scheduleId;
    private Map<String, CallTimeDataValue> values = new HashMap<String, CallTimeDataValue>();

    public CallTimeData(MeasurementScheduleRequest schedule) {
        this.scheduleId = schedule.getScheduleId();
    }

    public void addCallData(@NotNull String destination, @NotNull Date beginTime, long duration) {
        Date endTime = new Date(beginTime.getTime() + duration);
        CallTimeDataValue value = this.addValue(beginTime, endTime, destination);
        value.mergeCallTime(duration);
    }

    public void addAggregatedCallData(@NotNull String destination, @NotNull Date beginTime, @NotNull Date endTime, double minimum, double maximum, double total, long count) {
        if (count == 0L) {
            LOG.warn((Object)("Plugin attempted to add aggregated call data with a call count of 0 for destination '" + destination + "' - data will not be added."));
            return;
        }
        CallTimeDataValue value = this.addValue(beginTime, endTime, destination);
        value.setMinimum(minimum);
        value.setMaximum(maximum);
        value.setTotal(total);
        value.setCount(count);
    }

    public int getScheduleId() {
        return this.scheduleId;
    }

    @NotNull
    public Map<String, CallTimeDataValue> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    private CallTimeDataValue addValue(Date beginTime, Date endTime, String destination) {
        CallTimeDataValue value;
        if (beginTime.after(endTime)) {
            throw new IllegalArgumentException("Begin time (" + beginTime + " [" + beginTime.getTime() + "]) is after end time (" + endTime + " [" + endTime.getTime() + "]).");
        }
        if (destination.length() > 4000) {
            LOG.warn((Object)"Call destination is longer than the maximum length (4000 characters) - truncating it to 4000 characters...");
            destination = destination.substring(0, 4000);
        }
        if ((value = this.values.get(destination)) == null) {
            value = new CallTimeDataValue(beginTime, endTime);
            this.values.put(destination, value);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CallTimeData)) {
            return false;
        }
        CallTimeData other = (CallTimeData)o;
        return this.scheduleId == other.scheduleId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.scheduleId;
        return result;
    }
}

