/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource.composite;

import java.io.Serializable;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceFacets;

public class ResourceMembershipComposite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Resource resource;
    private Resource parent;
    private ResourceFacets resourceFacets;
    private boolean explicit;
    private boolean implicit;

    public ResourceMembershipComposite(Resource resource, Number explicitCount, Number implicitCount) {
        this(resource, null, explicitCount, implicitCount);
    }

    public ResourceMembershipComposite(Resource resource, Resource parent, Number explicitCount, Number implicitCount) {
        this.resource = resource;
        this.parent = parent;
        ResourceType resourceType = this.resource.getResourceType();
        this.explicit = explicitCount.intValue() > 0;
        this.implicit = implicitCount.intValue() > 0;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Resource getParent() {
        return this.parent;
    }

    public ResourceFacets getResourceFacets() {
        return this.resourceFacets;
    }

    public void setResourceFacets(ResourceFacets facets) {
        this.resourceFacets = facets;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public boolean getExplicit() {
        return this.explicit;
    }

    public void setExplicit(boolean isExplicit) {
        this.explicit = isExplicit;
    }

    public boolean getImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean isImplicit) {
        this.implicit = isImplicit;
    }

    public String toString() {
        return "ResourceMembershipComposite[" + this.resource.toString() + ", " + "explicit" + this.explicit + ", " + "implicit" + this.implicit + "]";
    }
}

