/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.logging.util.LoggerPluginWriter;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.connectionmanager.BaseConnectionManager2MBean;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.ConnectionCacheListener;
import org.jboss.resource.connectionmanager.ConnectionListener;
import org.jboss.resource.connectionmanager.ConnectionListenerFactory;
import org.jboss.resource.connectionmanager.ConnectionRecord;
import org.jboss.resource.connectionmanager.JTATransactionChecker;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;
import org.jboss.resource.connectionmanager.PreFillPoolSupport;
import org.jboss.security.SubjectFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.NotImplementedException;

public abstract class BaseConnectionManager2
extends ServiceMBeanSupport
implements BaseConnectionManager2MBean,
ConnectionCacheListener,
ConnectionListenerFactory,
TransactionTimeoutConfiguration,
JTATransactionChecker {
    private static final String SECURITY_MGR_PATH = "java:/jaas/";
    public static final String STOPPING_NOTIFICATION = "jboss.jca.connectionmanagerstopping";
    protected ObjectName managedConnectionPoolName;
    protected ManagedConnectionPool poolingStrategy;
    protected String jndiName;
    protected String securityDomainJndiName;
    protected SubjectFactory subjectFactory;
    protected ObjectName jaasSecurityManagerService;
    protected ObjectName ccmName;
    protected CachedConnectionManager ccm;
    protected boolean trace;
    protected int allocationRetry;
    protected long allocationRetryWaitMillis;
    protected AtomicBoolean shutdown = new AtomicBoolean(false);

    protected static void rethrowAsResourceException(String message, Throwable t) throws ResourceException {
        JBossResourceException.rethrowAsResourceException(message, t);
    }

    public BaseConnectionManager2() {
        this.trace = this.log.isTraceEnabled();
    }

    public BaseConnectionManager2(CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy) {
        this.ccm = ccm;
        this.poolingStrategy = poolingStrategy;
        this.trace = this.log.isTraceEnabled();
    }

    public ManagedConnectionPool getPoolingStrategy() {
        return this.poolingStrategy;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public ObjectName getManagedConnectionPool() {
        return this.managedConnectionPoolName;
    }

    public void setManagedConnectionPool(ObjectName newManagedConnectionPool) {
        this.managedConnectionPoolName = newManagedConnectionPool;
    }

    public void setCachedConnectionManager(ObjectName ccmName) {
        this.ccmName = ccmName;
    }

    public ObjectName getCachedConnectionManager() {
        return this.ccmName;
    }

    public void setSecurityDomainJndiName(String securityDomainJndiName) {
        if (securityDomainJndiName != null && securityDomainJndiName.startsWith(SECURITY_MGR_PATH)) {
            securityDomainJndiName = securityDomainJndiName.substring(SECURITY_MGR_PATH.length());
            this.log.warn((Object)"WARNING: UPDATE YOUR SecurityDomainJndiName! REMOVE java:/jaas/");
        }
        this.securityDomainJndiName = securityDomainJndiName;
    }

    public String getSecurityDomainJndiName() {
        return this.securityDomainJndiName;
    }

    public SubjectFactory getSubjectFactory() {
        return this.subjectFactory;
    }

    public void setSubjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    public ObjectName getJaasSecurityManagerService() {
        return this.jaasSecurityManagerService;
    }

    public void setJaasSecurityManagerService(ObjectName jaasSecurityManagerService) {
        this.jaasSecurityManagerService = jaasSecurityManagerService;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.poolingStrategy.getManagedConnectionFactory();
    }

    public BaseConnectionManager2 getInstance() {
        return this;
    }

    public void setAllocationRetry(int number) {
        if (number >= 0) {
            this.allocationRetry = number;
        }
    }

    public int getAllocationRetry() {
        return this.allocationRetry;
    }

    public void setAllocationRetryWaitMillis(long millis) {
        if (millis > 0L) {
            this.allocationRetryWaitMillis = millis;
        }
    }

    public long getAllocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException {
        return -1L;
    }

    public int getTransactionTimeout() throws SystemException {
        throw new NotImplementedException("NYI: getTransactionTimeout()");
    }

    public void checkTransactionActive() throws RollbackException, SystemException {
    }

    protected void startService() throws Exception {
        PreFillPoolSupport prefill;
        try {
            this.ccm = (CachedConnectionManager)this.server.getAttribute(this.ccmName, "Instance");
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
        }
        if (this.ccm == null) {
            throw new DeploymentException("cached ConnectionManager not found: " + this.ccmName);
        }
        if (this.managedConnectionPoolName == null) {
            throw new DeploymentException("managedConnectionPool not set!");
        }
        try {
            this.poolingStrategy = (ManagedConnectionPool)this.server.getAttribute(this.managedConnectionPoolName, "ManagedConnectionPool");
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
        }
        this.poolingStrategy.setConnectionListenerFactory(this);
        String categoryName = this.poolingStrategy.getManagedConnectionFactory().getClass().getName() + "." + this.jndiName;
        Logger log = Logger.getLogger((String)categoryName);
        LoggerPluginWriter logWriter = new LoggerPluginWriter(log.getLoggerPlugin());
        try {
            this.poolingStrategy.getManagedConnectionFactory().setLogWriter((PrintWriter)logWriter);
        }
        catch (ResourceException re) {
            log.warn((Object)("Unable to set log writer '" + logWriter + "' on " + "managed connection factory"), (Throwable)re);
            log.warn((Object)"Linked exception:", (Throwable)re.getLinkedException());
        }
        if (this.poolingStrategy instanceof PreFillPoolSupport && (prefill = (PreFillPoolSupport)((Object)this.poolingStrategy)).shouldPreFill()) {
            prefill.prefill();
        }
        this.shutdown.set(false);
    }

    protected void stopService() throws Exception {
        this.shutdown.set(true);
        this.sendNotification(new Notification(STOPPING_NOTIFICATION, this.getServiceName(), this.getNextNotificationSequenceNumber()));
        this.poolingStrategy.setConnectionListenerFactory(null);
        this.poolingStrategy = null;
        this.subjectFactory = null;
        this.ccm = null;
    }

    public ConnectionListener getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        return this.getManagedConnection(null, subject, cri);
    }

    protected ConnectionListener getManagedConnection(Transaction transaction, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ResourceException failure = null;
        if (this.shutdown.get()) {
            throw new ResourceException("The connection manager is shutdown " + this.jndiName);
        }
        try {
            return this.poolingStrategy.getConnection(transaction, subject, cri);
        }
        catch (ResourceException e) {
            failure = e;
            if (this.allocationRetry != 0) {
                for (int i = 0; i < this.allocationRetry; ++i) {
                    if (this.shutdown.get()) {
                        throw new ResourceException("The connection manager is shutdown " + this.jndiName);
                    }
                    if (this.trace) {
                        this.log.trace((Object)("Attempting allocation retry for cri=" + cri));
                    }
                    try {
                        if (this.allocationRetryWaitMillis != 0L) {
                            Thread.sleep(this.allocationRetryWaitMillis);
                        }
                        return this.poolingStrategy.getConnection(transaction, subject, cri);
                    }
                    catch (ResourceException e1) {
                        failure = e1;
                        continue;
                    }
                    catch (InterruptedException e1) {
                        JBossResourceException.rethrowAsResourceException("getManagedConnection retry wait was interrupted " + this.jndiName, e1);
                    }
                }
            }
            throw new ResourceException("Unable to get managed connection for " + this.jndiName, (Throwable)failure);
        }
    }

    public void returnManagedConnection(ConnectionListener cl, boolean kill) {
        ManagedConnectionPool localStrategy = cl.getManagedConnectionPool();
        if (localStrategy != this.poolingStrategy) {
            kill = true;
        }
        try {
            if (!kill && cl.getState() == 0) {
                cl.tidyup();
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during tidyup " + cl), t);
            kill = true;
        }
        try {
            localStrategy.returnConnection(cl, kill);
        }
        catch (ResourceException re) {
            if (kill) {
                this.log.debug((Object)"resourceException killing connection (error retrieving from pool?)", (Throwable)re);
            }
            this.log.warn((Object)("resourceException returning connection: " + cl.getManagedConnection()), (Throwable)re);
        }
    }

    public int getConnectionCount() {
        return this.poolingStrategy.getConnectionCount();
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        if (this.poolingStrategy == null) {
            throw new ResourceException("You are trying to use a connection factory that has been shut down: ManagedConnectionFactory is null.");
        }
        if (!this.poolingStrategy.getManagedConnectionFactory().equals(mcf)) {
            throw new ResourceException("Wrong ManagedConnectionFactory sent to allocateConnection!");
        }
        Subject subject = this.getSubject();
        ConnectionListener cl = this.getManagedConnection(subject, cri);
        this.reconnectManagedConnection(cl);
        Object connection = null;
        try {
            connection = cl.getManagedConnection().getConnection(subject, cri);
        }
        catch (Throwable t) {
            try {
                this.managedConnectionDisconnected(cl);
            }
            catch (ResourceException re) {
                this.log.trace((Object)("Get exception from managedConnectionDisconnected, maybe delist() have problem" + (Object)((Object)re)));
                this.returnManagedConnection(cl, true);
            }
            JBossResourceException.rethrowAsResourceException("Unchecked throwable in ManagedConnection.getConnection() cl=" + cl, t);
        }
        this.registerAssociation(cl, connection);
        if (this.ccm != null) {
            this.ccm.registerConnection(this, cl, connection, cri);
        }
        return connection;
    }

    public void transactionStarted(Collection conns) throws SystemException {
    }

    public void reconnect(Collection conns, Set unsharableResources) throws ResourceException {
        if (unsharableResources.contains(this.jndiName)) {
            this.log.trace((Object)"reconnect for unshareable connection: nothing to do");
            return;
        }
        HashMap<ConnectionRequestInfo, ConnectionListener> criToCLMap = new HashMap<ConnectionRequestInfo, ConnectionListener>();
        for (ConnectionRecord cr : conns) {
            ConnectionListener cl;
            if (cr.cl != null) {
                this.log.warn((Object)("reconnecting a connection handle that still has a managedConnection! " + cr.cl.getManagedConnection() + " " + cr.connection));
            }
            if ((cl = (ConnectionListener)criToCLMap.get(cr.cri)) == null) {
                cl = this.getManagedConnection(this.getSubject(), cr.cri);
                criToCLMap.put(cr.cri, cl);
                this.reconnectManagedConnection(cl);
            }
            cl.getManagedConnection().associateConnection(cr.connection);
            this.registerAssociation(cl, cr.connection);
            cr.setConnectionListener(cl);
        }
        criToCLMap.clear();
    }

    public void disconnect(Collection crs, Set unsharableResources) throws ResourceException {
        if (unsharableResources.contains(this.jndiName)) {
            this.log.trace((Object)"disconnect for unshareable connection: nothing to do");
            return;
        }
        HashSet<ConnectionListener> cls = new HashSet<ConnectionListener>();
        for (ConnectionRecord cr : crs) {
            ConnectionListener cl = cr.cl;
            cr.setConnectionListener(null);
            this.unregisterAssociation(cl, cr.connection);
            if (cls.contains(cl)) continue;
            cls.add(cl);
        }
        Iterator i = cls.iterator();
        while (i.hasNext()) {
            this.disconnectManagedConnection((ConnectionListener)i.next());
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return super.getNotificationInfo();
    }

    protected void unregisterAssociation(ConnectionListener cl, Object c) {
        cl.unregisterConnection(c);
    }

    protected void reconnectManagedConnection(ConnectionListener cl) throws ResourceException {
        try {
            this.managedConnectionReconnected(cl);
        }
        catch (Throwable t) {
            this.disconnectManagedConnection(cl);
            JBossResourceException.rethrowAsResourceException("Unchecked throwable in managedConnectionReconnected() cl=" + cl, t);
        }
    }

    protected void disconnectManagedConnection(ConnectionListener cl) {
        try {
            this.managedConnectionDisconnected(cl);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Unchecked throwable in managedConnectionDisconnected() cl=" + cl), t);
        }
    }

    protected final CachedConnectionManager getCcm() {
        return this.ccm;
    }

    protected void managedConnectionReconnected(ConnectionListener cl) throws ResourceException {
    }

    protected void managedConnectionDisconnected(ConnectionListener cl) throws ResourceException {
    }

    private void registerAssociation(ConnectionListener cl, Object c) throws ResourceException {
        cl.registerConnection(c);
    }

    private Subject getSubject() {
        Subject subject = null;
        if (this.subjectFactory != null && this.securityDomainJndiName != null) {
            subject = this.subjectFactory.createSubject(this.securityDomainJndiName);
        }
        if (this.trace) {
            this.log.trace((Object)("subject: " + subject));
        }
        return subject;
    }

    public boolean isTransactional() {
        return false;
    }

    public TransactionManager getTransactionManagerInstance() {
        return null;
    }

    public static class ConnectionManagerProxy
    implements ConnectionManager,
    Serializable,
    TransactionTimeoutConfiguration,
    JTATransactionChecker {
        static final long serialVersionUID = -528322728929261214L;
        private transient BaseConnectionManager2 realCm;
        private final ObjectName cmName;

        ConnectionManagerProxy(BaseConnectionManager2 realCm, ObjectName cmName) {
            this.realCm = realCm;
            this.cmName = cmName;
        }

        public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
            return this.getCM().allocateConnection(mcf, cri);
        }

        public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException {
            try {
                return this.getCM().getTimeLeftBeforeTransactionTimeout(errorRollback);
            }
            catch (ResourceException e) {
                throw new NestedRuntimeException("Unable to retrieve connection manager", (Throwable)e);
            }
        }

        public int getTransactionTimeout() throws SystemException {
            try {
                return this.getCM().getTransactionTimeout();
            }
            catch (ResourceException e) {
                throw new NestedRuntimeException("Unable to retrieve connection manager", (Throwable)e);
            }
        }

        public void checkTransactionActive() throws RollbackException, SystemException {
            try {
                this.getCM().checkTransactionActive();
            }
            catch (ResourceException e) {
                throw new NestedRuntimeException("Unable to retrieve connection manager", (Throwable)e);
            }
        }

        private BaseConnectionManager2 getCM() throws ResourceException {
            if (this.realCm == null) {
                try {
                    MBeanServer server = MBeanServerLocator.locateJBoss();
                    this.realCm = (BaseConnectionManager2)server.getAttribute(this.cmName, "Instance");
                }
                catch (Throwable t) {
                    Throwable t2 = JMXExceptionDecoder.decode((Throwable)t);
                    JBossResourceException.rethrowAsResourceException("Problem locating real ConnectionManager: " + this.cmName, t2);
                }
            }
            return this.realCm;
        }
    }

    protected abstract class BaseConnectionEventListener
    implements ConnectionListener {
        private final ManagedConnection mc;
        private final ManagedConnectionPool mcp;
        private final Object context;
        private int state = 0;
        private final List handles = new LinkedList();
        private long lastUse;
        private AtomicBoolean trackByTx = new AtomicBoolean(false);
        private boolean permit = false;
        protected Logger log;
        protected boolean trace;
        protected long lastValidated;

        protected BaseConnectionEventListener(ManagedConnection mc, ManagedConnectionPool mcp, Object context, Logger log) {
            this.mc = mc;
            this.mcp = mcp;
            this.context = context;
            this.log = log;
            this.trace = log.isTraceEnabled();
            this.lastUse = System.currentTimeMillis();
        }

        public ManagedConnection getManagedConnection() {
            return this.mc;
        }

        public ManagedConnectionPool getManagedConnectionPool() {
            return this.mcp;
        }

        public Object getContext() {
            return this.context;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int newState) {
            this.state = newState;
        }

        public boolean isTimedOut(long timeout) {
            return this.lastUse < timeout;
        }

        public void used() {
            this.lastUse = System.currentTimeMillis();
        }

        public boolean isTrackByTx() {
            return this.trackByTx.get();
        }

        public void setTrackByTx(boolean trackByTx) {
            this.trackByTx.set(trackByTx);
        }

        public void tidyup() throws ResourceException {
        }

        public synchronized void registerConnection(Object handle) {
            this.handles.add(handle);
        }

        public synchronized void unregisterConnection(Object handle) {
            if (!this.handles.remove(handle)) {
                this.log.info((Object)("Unregistered handle that was not registered! " + handle + " for managedConnection: " + this.mc));
            }
            if (this.trace) {
                this.log.trace((Object)("unregisterConnection: " + this.handles.size() + " handles left"));
            }
        }

        public synchronized boolean isManagedConnectionFree() {
            return this.handles.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void unregisterConnections() {
            try {
                Iterator i = this.handles.iterator();
                while (i.hasNext()) {
                    BaseConnectionManager2.this.getCcm().unregisterConnection(BaseConnectionManager2.this, i.next());
                }
            }
            finally {
                this.handles.clear();
            }
        }

        public void connectionErrorOccurred(ConnectionEvent ce) {
            if (this.state == 0) {
                if (ce != null) {
                    Exception t = ce.getException();
                    if (t == null) {
                        t = new Exception("No exception was reported");
                    }
                    this.log.warn((Object)("Connection error occured: " + this), (Throwable)t);
                } else {
                    Exception t = new Exception("No exception was reported");
                    this.log.warn((Object)("Unknown Connection error occured: " + this), (Throwable)t);
                }
            }
            try {
                this.unregisterConnections();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ce != null && ce.getSource() != this.getManagedConnection()) {
                this.log.warn((Object)"Notified of error on a different managed connection?");
            }
            BaseConnectionManager2.this.returnManagedConnection(this, true);
        }

        public void enlist() throws SystemException {
        }

        public void delist() throws ResourceException {
        }

        public boolean hasPermit() {
            return this.permit;
        }

        public void grantPermit(boolean value) {
            this.permit = value;
        }

        public long getLastValidatedTime() {
            return this.lastValidated;
        }

        public void setLastValidatedTime(long lastValidated) {
            this.lastValidated = lastValidated;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(this.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(this)));
            buffer.append("[state=");
            if (this.state == 0) {
                buffer.append("NORMAL");
            } else if (this.state == 1) {
                buffer.append("DESTROY");
            } else if (this.state == 2) {
                buffer.append("DESTROYED");
            } else {
                buffer.append("UNKNOWN?");
            }
            buffer.append(" mc=").append(this.mc);
            buffer.append(" handles=").append(this.handles.size());
            buffer.append(" lastUse=").append(this.lastUse);
            buffer.append(" permit=").append(this.permit);
            buffer.append(" trackByTx=").append(this.trackByTx.get());
            buffer.append(" mcp=").append(this.mcp);
            buffer.append(" context=").append(this.context);
            this.toString(buffer);
            buffer.append(']');
            return buffer.toString();
        }

        protected void toString(StringBuffer buffer) {
        }
    }
}

