/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.descriptor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.util.exception.WrappedRemotingException;

public abstract class AgentPluginDescriptorUtil {
    private static final String PLUGIN_DESCRIPTOR_PATH = "META-INF/rhq-plugin.xml";
    private static final String PLUGIN_SCHEMA_PATH = "rhq-plugin.xsd";

    public static PluginDescriptor loadPluginDescriptorFromUrl(URL pluginJarFileUrl) throws PluginContainerException {
        JAXBContext jaxbContext;
        Log logger = LogFactory.getLog(AgentPluginDescriptorUtil.class);
        if (pluginJarFileUrl == null) {
            throw new PluginContainerException("A valid plugin JAR URL must be supplied.");
        }
        logger.debug((Object)("Loading plugin descriptor from plugin jar at [" + pluginJarFileUrl + "]..."));
        AgentPluginDescriptorUtil.testPluginJarIsReadable(pluginJarFileUrl);
        try {
            jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.plugin");
        }
        catch (Exception e) {
            throw new PluginContainerException("Failed to create JAXB Context.", (Throwable)new WrappedRemotingException((Throwable)e));
        }
        JarInputStream jis = null;
        JarEntry descriptorEntry = null;
        try {
            jis = new JarInputStream(pluginJarFileUrl.openStream());
            JarEntry nextEntry = jis.getNextJarEntry();
            while (nextEntry != null && descriptorEntry == null) {
                if (PLUGIN_DESCRIPTOR_PATH.equals(nextEntry.getName())) {
                    descriptorEntry = nextEntry;
                    continue;
                }
                jis.closeEntry();
                nextEntry = jis.getNextJarEntry();
            }
            if (descriptorEntry == null) {
                throw new Exception("The plugin descriptor does not exist");
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            URL pluginSchemaURL = AgentPluginDescriptorUtil.class.getClassLoader().getResource(PLUGIN_SCHEMA_PATH);
            Schema pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
            unmarshaller.setSchema(pluginSchema);
            ValidationEventCollector vec = new ValidationEventCollector();
            unmarshaller.setEventHandler((ValidationEventHandler)vec);
            PluginDescriptor pluginDescriptor = (PluginDescriptor)unmarshaller.unmarshal((InputStream)jis);
            for (ValidationEvent event : vec.getEvents()) {
                logger.debug((Object)("Plugin [" + pluginDescriptor.getName() + "] descriptor messages {Severity: " + event.getSeverity() + ", Message: " + event.getMessage() + ", Exception: " + event.getLinkedException() + "}"));
            }
            PluginDescriptor pluginDescriptor2 = pluginDescriptor;
            return pluginDescriptor2;
        }
        catch (Exception e) {
            throw new PluginContainerException("Could not successfully parse the plugin descriptor [META-INF/rhq-plugin.xml found in plugin jar at [" + pluginJarFileUrl + "]", (Throwable)new WrappedRemotingException((Throwable)e));
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (Exception e) {
                    logger.warn((Object)("Cannot close jar stream [" + pluginJarFileUrl + "]. Cause: " + e));
                }
            }
        }
    }

    private static void testPluginJarIsReadable(URL pluginJarFileUrl) throws PluginContainerException {
        InputStream inputStream = null;
        try {
            inputStream = pluginJarFileUrl.openStream();
        }
        catch (IOException e) {
            throw new PluginContainerException("Unable to open plugin jar at [" + pluginJarFileUrl + "] for reading.");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ignore) {}
        }
    }
}

