/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.interfaces;

import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.jboss.logging.Logger;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalOnlyContextFactory
implements InitialContextFactory {
    private static final Logger log = Logger.getLogger(LocalOnlyContextFactory.class);
    private static ConcurrentHashMap<String, WeakReference<Naming>> localServers = new ConcurrentHashMap();
    private Naming naming;

    public Naming getNaming() {
        return this.naming;
    }

    public void setNaming(Naming naming) {
        this.naming = naming;
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("getInitialContext, env: " + env);
        }
        String name = null;
        Naming localServer = null;
        if (env != null) {
            localServer = (Naming)env.get("jnp.namingInstance");
            if (trace && localServer != null) {
                log.trace("Set naming from jnp.namingInstance");
            }
            name = (String)env.get("jnp.namingInstanceName");
        }
        if (localServer == null) {
            localServer = this.naming;
            if (trace && localServer != null) {
                log.trace("Set naming from injected value");
            }
        }
        if (localServer == null && name != null) {
            WeakReference<Naming> lswr = localServers.get(name);
            if (lswr != null) {
                localServer = (Naming)lswr.get();
            }
            if (trace && localServer != null) {
                log.trace("Set naming from jnp.namingInstanceName=" + name);
            }
        }
        if (localServer == null) {
            localServer = NamingContext.getLocal();
            if (trace && localServer != null) {
                log.trace("Set naming from NamingContext.getLocal");
            }
        }
        if (localServer == null) {
            throw new NamingException("Failed to determine local server from: " + env);
        }
        if (name != null && !localServers.containsKey(name)) {
            localServers.put(name, new WeakReference<Naming>(localServer));
            if (trace) {
                log.trace("Set localServers:" + name);
            }
        }
        if (env == null) {
            env = new Hashtable();
        }
        return new NamingContext(env, null, localServer);
    }
}

