/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.ws.core.soap.MessageFactoryImpl;
import org.jboss.ws.extensions.json.BadgerFishDOMDocumentParser;
import org.w3c.dom.Document;

public class JsonMessageUnMarshaller
implements UnMarshaller {
    private static Logger log = Logger.getLogger(JsonMessageUnMarshaller.class);

    public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read input stream with metadata=" + metadata));
        }
        try {
            MessageFactoryImpl factory = new MessageFactoryImpl();
            SOAPMessage soapMsg = factory.createMessage();
            Document doc = new BadgerFishDOMDocumentParser().parse(inputStream);
            soapMsg.getSOAPBody().addDocument(doc);
            return soapMsg;
        }
        catch (SOAPException ex) {
            IOException ioex = new IOException("Cannot unmarshall json input stream");
            ioex.initCause(ex);
            throw ioex;
        }
    }

    public void setClassLoader(ClassLoader classloader) {
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        return new JsonMessageUnMarshaller();
    }

    private MimeHeaders getMimeHeaders(Map metadata) {
        log.debug((Object)("getMimeHeaders from: " + metadata));
        MimeHeaders headers = new MimeHeaders();
        for (String key : metadata.keySet()) {
            Object value = metadata.get(key);
            if (key == null || !(value instanceof List)) continue;
            for (Object listValue : (List)value) {
                headers.addHeader(key, listValue.toString());
            }
        }
        return headers;
    }
}

