/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.jdbc;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.JDBCImple;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class sqlserver_driver
extends JDBCImple {
    private static final int _maxStateSize = 65535;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputObjectState read_state(Uid objUid, String tName, int ft, String tableName) throws ObjectStoreException {
        InputObjectState newImage = null;
        if (!this.storeValid()) {
            return newImage;
        }
        if (tName == null) throw new ObjectStoreException("sqlserver.read_state - object with uid " + objUid + " has no TypeName");
        if (ft != 1 && ft != 2) return newImage;
        int pool = this.getPool();
        ResultSet rs = null;
        try {
            PreparedStatement pstmt = this._preparedStatements[pool][4];
            if (pstmt == null) {
                this._preparedStatements[pool][4] = pstmt = this._theConnection[pool].prepareStatement("SELECT ObjectState FROM " + tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ?");
            }
            pstmt.setString(1, objUid.stringForm());
            pstmt.setString(2, tName);
            pstmt.setInt(3, ft);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                InputObjectState inputObjectState = null;
                return inputObjectState;
            }
            byte[] buffer = rs.getBytes(1);
            if (buffer != null) {
                newImage = new InputObjectState(objUid, tName, buffer);
                return newImage;
            } else {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) return newImage;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.jdbc.sqlserver_1");
            }
            return newImage;
        }
        catch (Throwable e) {
            if (!this.retryConnection(e, pool)) throw new ObjectStoreException(e.toString());
            InputObjectState inputObjectState = this.read_state(objUid, tName, ft, tableName);
            return inputObjectState;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception re) {}
            this.freePool(pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write_state(Uid objUid, String tName, OutputObjectState state, int s, String tableName) throws ObjectStoreException {
        boolean result = false;
        int imageSize = state.length();
        if (imageSize > 65535) {
            throw new ObjectStoreException("Object state is too large - maximum size allowed: 65535");
        }
        byte[] b = state.buffer();
        if (imageSize > 0 && this.storeValid()) {
            int pool = this.getPool();
            ResultSet rs = null;
            try {
                PreparedStatement pstmt = this._preparedStatements[pool][9];
                if (pstmt == null) {
                    this._preparedStatements[pool][9] = pstmt = this._theConnection[pool].prepareStatement("SELECT ObjectState FROM " + tableName + " WHERE UidString = ? AND StateType = ? AND TypeName = ?", 1003, 1008);
                }
                pstmt.setString(1, objUid.stringForm());
                pstmt.setInt(2, s);
                pstmt.setString(3, tName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rs.updateBytes(1, b);
                    rs.updateRow();
                } else {
                    PreparedStatement pstmt2 = this._preparedStatements[pool][6];
                    if (pstmt2 == null) {
                        this._preparedStatements[pool][6] = pstmt2 = this._theConnection[pool].prepareStatement("INSERT INTO " + tableName + " (StateType,TypeName,UidString,ObjectState) VALUES (?,?,?,?)");
                    }
                    pstmt2.setInt(1, s);
                    pstmt2.setString(2, tName);
                    pstmt2.setString(3, objUid.stringForm());
                    pstmt2.setBytes(4, b);
                    pstmt2.executeUpdate();
                    this._theConnection[pool].commit();
                }
                this._theConnection[pool].commit();
                result = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (this.retryConnection(e, pool)) {
                    boolean bl = this.write_state(objUid, tName, state, s, tableName);
                    return bl;
                }
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.jdbc.sqlserver_2", new Object[]{e});
                }
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception re) {}
                this.freePool(pool);
            }
        }
        return result;
    }

    protected void createTable(Statement stmt, String tableName) throws SQLException {
        stmt.executeUpdate("CREATE TABLE " + tableName + " (StateType INTEGER, TypeName VARCHAR(1024), UidString VARCHAR(255), ObjectState IMAGE, PRIMARY KEY(UidString, StateType, TypeName))");
    }

    public String name() {
        return "sqlserver";
    }
}

