/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.jcr;

import java.util.ArrayList;
import java.util.Collection;

public class QuerySpec {
    private int first;
    private int max;
    private Collection<Condition> conditions = new ArrayList<Condition>();
    private Collection<SortSpec> sorts = new ArrayList<SortSpec>();

    public void addSort(String sortBy, SortOrder sortOrder) {
        this.sorts.add(new SortSpec(sortBy, sortOrder));
    }

    public void addCondition(String field, Operation operation, String value) {
        this.conditions.add(new Condition(field, operation, value));
    }

    public String getJCRCondition() {
        StringBuilder sb = new StringBuilder();
        for (Condition condition : this.conditions) {
            if (sb.length() == 0) {
                sb.append(" AND ").append(condition);
                continue;
            }
            sb.append(condition);
        }
        return sb.toString();
    }

    public String getOrderByClause() {
        StringBuilder sbs = new StringBuilder();
        for (SortSpec sort : this.sorts) {
            if (sbs.length() == 0) {
                sbs.append(",").append(sort);
                continue;
            }
            sbs.append(sort);
        }
        return sbs.toString();
    }

    public int getFirst() {
        return this.first;
    }

    public void setFirst(int first) {
        this.first = first;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    class Condition {
        String field;
        Operation operation;
        String value;

        public Condition(String field, Operation operation, String value) {
            this.field = field;
            this.operation = operation;
            this.value = value;
        }

        public String toString() {
            switch (this.operation) {
                case contains: {
                    return "CONTAINS($" + this.field + "'" + this.value + "')";
                }
                case equals: {
                    return "$" + this.field + "='" + this.value + "'";
                }
                case startsWith: {
                    return "$" + this.field + " LIKE '" + this.value + "%'";
                }
                case present: {
                    return "$" + this.field + " IS NOT NULL";
                }
                case greaterThan: {
                    return "$" + this.field + ">'" + this.value + "'";
                }
            }
            return "";
        }
    }

    class SortSpec {
        private String sortBy;
        private SortOrder sortOrder;

        public SortSpec(String sortBy, SortOrder sortOrder) {
            this.sortBy = sortBy;
            this.sortOrder = sortOrder;
        }

        public String toString() {
            return this.sortBy + " " + (Object)((Object)this.sortOrder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortOrder {
        asc,
        desc;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        contains,
        equals,
        startsWith,
        present,
        greaterThan;

    }
}

